<?php

namespace App\Services\Reports;

use App\Models\CRMTickets;
use App\Models\Sales;
use App\Services\ExcelExportService;
use App\Services\Reports\ReportService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use DB;

class SalesReportService
{
    private $reportService;
    private $excelExportService;

    public function __construct(ReportService $reportService, ExcelExportService $excelExportService)
    {
        $this->reportService = $reportService;
        $this->excelExportService = $excelExportService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);
        $fromDate = Carbon::parse($args->fromDate)->format('Y-m-d');
        $toDate = Carbon::parse($args->toDate)->format('Y-m-d');
        $sql = Sales::select(
            'branch_master.name as branchName',
            'sales.*',
            'cluster_master.name as clusterName',
            DB::raw('DATE_FORMAT(sales.invoice_date, "%d-%m-%Y") as invoice_date'),
            DB::raw('DATE_FORMAT(sales.followup_date, "%d-%m-%Y") as followup_date')
        )
            ->leftJoin('branch_master', 'branch_master.id', 'sales.branch_id')
            ->where('sales.invoice_date', '>=', $fromDate)
            ->where('sales.invoice_date', '<=', $toDate)
            ->leftJoin('cluster_branch_mapping', 'cluster_branch_mapping.branch_id', 'branch_master.id')
            ->leftJoin('cluster_master', 'cluster_master.id', 'cluster_branch_mapping.cluster_id');

        if ($args->telecallingSales == 'true' || $args->telecallingSales == 'on') {
            $sql->join('beneficiary_import', 'beneficiary_import.id', 'sales.beneficiary_id');
        }
        if ($args->branch && $args->branch != 'All') {
            $sql->where('sales.branch_id', $args->branch);
        }
        if ($args->cluster && $args->cluster != 'All') {
            $sql->where('cluster_master.id', $args->cluster);
        }
        return $sql;
    }

    function getSalesReportExcel(Request $request)
    {
        $sql = $this->getData($request);
        $data = $sql->get();
        $args = $this->reportService->processrequestFilters($request);
        $params = clone $args;
        $params->type = 'sales-report-excel';
        $params->branchLabel = $this->reportService->getBranchById($args->branch);
        $params->clusterLabel = $this->reportService->getClusterById($args->cluster);
        return $this->excelExportService->exportExcel($params, $data);
    }
}
