<?php

namespace App\Services\Reports;

use App\Models\EnquiryHistory;
use App\Models\Masters\BranchMaster;
use App\Models\Masters\BrandMaster;
use App\Services\ExcelExportService;
use App\Services\Reports\ReportService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Collection;
use stdClass;

class SalientSummaryService
{
    private $reportService;
    private $excelExportService;

    public function __construct(ReportService $reportService, ExcelExportService $excelExportService)
    {
        $this->reportService = $reportService;
        $this->excelExportService = $excelExportService;
    }

    function getDatesBetween($startDate, $endDate)
    {
        $dates = new Collection();
        $currentDate = Carbon::parse($startDate);
        $endDate = Carbon::parse($endDate);

        while ($currentDate->lte($endDate)) {
            $item = new stdClass;
            $item->dbFormat = $currentDate->format('Y-m-d');
            $item->displayFormat = $currentDate->format('d/m/Y');
            $dates->add($item);
            $currentDate->addDay();
        }
        return $dates;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);
        $fromDate = Carbon::parse($args->years . '-' . $args->months . '-01')->format('Y-m-d');
        $toDate = Carbon::parse($fromDate)->endOfMonth()->format('Y-m-d');
        $args->fromDate = $fromDate;
        $args->toDate = $toDate;
        $sql = EnquiryHistory::select(
            'branch_master.name as branchName',
            'enquiry_history.product',
            'enquiry_history.date',
            'enquiry_history.branch_id',
            'enquiry_history.enquiry_reason',
            DB::raw('SUM(CASE WHEN enquiry_history.amount IS NOT NULL THEN enquiry_history.qty ELSE "" END) as qty'),
            DB::raw('SUM(enquiry_history.qty * enquiry_history.amount) as price'),
        )
            ->leftJoin('branch_master', 'branch_master.id', 'enquiry_history.branch_id')
            ->where('date', '>=', $args->fromDate)
            ->where('date', '<=', $args->toDate);

        $dateSql = clone $sql;
        $productSql = clone $sql;
        $enquirySql = clone $sql;

        $dateWiseData = $dateSql->groupBy('enquiry_history.date', 'enquiry_history.branch_id')->get();
        $productWiseData = $productSql->groupBy('enquiry_history.product')->get();
        $enquiryWiseData = $enquirySql->groupBy('enquiry_history.enquiry_reason')->get();

        $dates = $this->getDatesBetween($args->fromDate, $args->toDate);
        $branches = BranchMaster::select('id', 'name')->whereStatus(BranchMaster::STATUS_ACTIVE)->get();

        $result = new stdClass;
        $result->productWiseData = $productWiseData;
        $result->enquiryWiseData = $enquiryWiseData;
        $result->dateWiseData = $dateWiseData;
        $result->dates = $dates;
        $result->branches = $branches;

        return $result;
    }

    function getReportExcel(Request $request)
    {
        $data = $this->getData($request);
        $args = $this->reportService->processrequestFilters($request);
        $params = clone $args;
        $params->type = 'sales-analysis-report-excel';
        $params->branchLabel = $this->reportService->getBranchById($args->branch);
        return $this->excelExportService->exportExcel($params, $data);
    }
}
