<?php

namespace App\Services;

class SmsNotificationService
{

    public function __construct()
    {
    }

    public function sendSmsNotificaition($args)
    {
        $apiKey = urlencode(constants('SMS_API_KEY'));
        $numbers = array($args->mobileNumbers);
        $sender = urlencode(constants('SMS_SENDER'));
        $message = $args->message;
        if ($args->encodeMsg) {
            $message = rawurlencode($args->message);
        }
        $numbers = implode(',', $numbers);
        $data = array('apikey' => $apiKey, 'numbers' => $numbers, 'sender' => $sender, 'message' => $message);
        if (isset($args->unicode)) {
            $data['unicode'] = $args->unicode;
        }
        $ch = curl_init('https://api.textlocal.in/send/');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
        $response = json_decode($response, true);
        return $response;
    }

    public function createTinyUrl($url)
    {
        $ch = curl_init();
        $timeout = 5;
        curl_setopt($ch, CURLOPT_URL, 'http://tinyurl.com/api-create.php?url=' . $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;
    }
}
