<?php

namespace App\Services;

use App\Models\CustomerSpecialitiesDocs;
use App\Models\Specialities;
use App\Services\CommonService;
use Illuminate\Http\Request;
use DB;

class SpecialitiesService
{
    private $commonService;
    public function __construct(CommonService $commonService)
    {
        $this->commonService = $commonService;
    }

    public function getSpecialities(Request $request)
    {
        $userId = $request->user()->id;
        $data = Specialities::select(
            'id',
            'name',
            DB::raw('CONCAT("' . url(Specialities::FILE_UPLOAD_PATH) . '/", image) as imagePath'),
        )
            ->whereStatus(Specialities::STATUS_ACTIVE)
            ->where(function ($query) use ($userId) {
                $query->orWhereRaw('customer_id IS NULL OR customer_id = ' . $userId . '');
            })
            ->get();
        return $data;
    }

    public function getUploadedDocs(Request $request)
    {
        $sql = CustomerSpecialitiesDocs::select(
            DB::raw('DATE_FORMAT(created_at, "%M %d, %Y") as dateList'),
            DB::raw('DATE_FORMAT(created_at, "%Y-%m-%d") as date'),
            'specialities_id',
            'doc_type'
        )
            ->where('customer_id',  $request->user()->id)
            ->where('specialities_id',  $request->specialitiesId);
        if ($request->date) {
            if ($request->searchTxt) {
                $sql->where('doc_name', 'LIKE', '%' . $request->searchTxt . '%');
            }
            $sql->whereDate('created_at', $request->date);
            $sql->addSelect(
                'doc_name',
                'id',
                DB::raw('DATE_FORMAT(CONVERT_TZ(created_at, "+00:00", "+05:30"), "%W, %l:%i %p") as dateTime'),
                DB::raw('CONCAT("' . url(CustomerSpecialitiesDocs::FILE_UPLOAD_PATH) . '/", doc_path) as imagePath'),
            );
        } else {
            if ($request->fromDate && $request->toDate) {
                $sql->whereDate('created_at', '>=', $request->fromDate);
                $sql->whereDate('created_at', '<=', $request->toDate);
            }
            $sql->groupBy(DB::raw('DATE(created_at)'));
        }
        $data = $sql->get();
        return $data;
    }

    function saveSpecialities(Request $request)
    {
        if (!$request->name) {
            return $this->commonService->makeErrorResponse('speciality name mandatory');
        }
        if (!$request->image) {
            return $this->commonService->makeErrorResponse('speciality image mandatory');
        }

        $imagePath = 'uploads/specialities/';
        $fileName = $this->commonService->saveBase64Image($request->image, $imagePath);

        $speciality = new Specialities();
        $speciality->name = $request->name;
        $speciality->customer_id = $request->user()->id;
        $speciality->image = $fileName;
        $speciality->ip_address = userIpAddress($request);
        if ($speciality->save()) {
            return $this->commonService->makeSuccessResponse('speciality saved successfully', $speciality);
        }
    }

    function uploadSpecialitiesDocs(Request $request)
    {
        $fileName = '';
        // if ($request->hasFile('document')) {
        //     $file = $request->document;
        //     if ($request->docType == CustomerSpecialitiesDocs::DOC_TYPE_SCAN) {
        //         if (!$request->docName) {
        //             return $this->commonService->makeErrorResponse('document name mandatory');
        //         }
        //         $fileorg = $request->docName;
        //     } else {
        //         $fileorg = $file->getClientOriginalName();
        //         $fileorg = pathinfo($fileorg, PATHINFO_FILENAME);
        //     }
        //     $fileName = $fileorg . '_' . $request->user()->id . '.' . $file->extension();
        //     $file->move(storage_path('uploads/specialities/user_docs/'), $fileName);
        // }

        if (!$request->docName) {
            return $this->commonService->makeErrorResponse('document name mandatory');
        }

        $imagePath = 'uploads/specialities/user_docs/';
        if ($request->document && $request->docName) {
            $fileArr = explode('.', $request->docName);
            $extension = $fileArr[1];
            if ($extension) {
                if ($extension == 'pdf') {
                    $fileName = $this->commonService->saveBase64Pdf($request->document, $imagePath);
                } else {
                    $extension = '.' . $extension;
                    $fileName = $this->commonService->saveBase64Image($request->document, $imagePath, $extension);
                }
            } else {
                return $this->commonService->makeErrorResponse('file extension not found');
            }
        }

        if ($fileName == '') {
            return $this->commonService->makeErrorResponse('document mandatory');
        }

        $data = new CustomerSpecialitiesDocs();
        $data->specialities_id = $request->specialityId;
        $data->customer_id = $request->user()->id;
        $data->doc_type = $request->docType;
        $data->doc_name = $request->docName;
        $data->doc_path = $fileName;
        $data->created_by = $request->user()->id;
        $data->updated_by = $request->user()->id;
        $data->ip_address = userIpAddress($request);
        if ($data->save()) {
            return $this->commonService->makeSuccessResponse('Document uploaded successfully', $data);
        }
        return $this->commonService->makeErrorResponse('failed to save');
    }

    function renameUploadedDocs(Request $request)
    {
        $data = CustomerSpecialitiesDocs::find($request->docId);
        if ($data) {
            $data->doc_name = $request->docName;
            if ($data->save()) {
                return $this->commonService->makeSuccessResponse('Document updated successfully', $data);
            }
        }
        return $this->commonService->makeErrorResponse('failed to save');
    }
}
