<?php

namespace App\Services\Transactions;

use App\Models\Masters\BrandMaster;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;
use stdClass;

class ResendCouponsService
{

    public function __construct() {}

    public function getData()
    {
        $data = BrandMaster::orderBy('id');
        return $data;
    }

    public function isNew($id = null)
    {

        $data = new stdClass;
        $data->route = route('resend-coupons.store');
        $data->method = 'POST';
        $data->breadcrumbName = 'Create';
        $data->breadcrumbAction = route('resend-coupons.index');
        $data->breadcrumbTitle = 'Resend Coupons';
        $data->sampleTemplateBreadcrumbAction = route('downloadAttachments', ['type' => 'sample_resend_coupons', 'file' => 'resend_coupon_codes_sample.xlsx']);
        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $code = $request->has('code') ? $request->get('code') : '';

        if ($id) {
            $data = BrandMaster::find($id);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new BrandMaster();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }
        $data->name = $name;
        $data->code = $code;

        $data->save();

        if ($data) {
            return true;
        }
    }
}
