<?php

use App\Models\RoleMaster;
use App\Utilities\AppClass;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use Laravel\Sanctum\PersonalAccessToken;

function constants($value)
{
    return config('constants.' . $value);
}

function appVersion()
{
    return constants('APP_VERSION');
}

function getRouteArgs($route)
{
    $args = new AppClass();
    $args->editRouteName = $route . '.edit';
    $args->activeRouteName = 'common.active';
    $args->inactiveRouteName = 'common.inactive';
    $args->deleteRouteName = 'common.delete';
    $args->createRouteName = $route . '.create';
    $args->showRouteName = $route . '.show';
    $args->dropDownDesign = true;
    $args->breadcrumbName = 'List';
    $args->breadcrumbAction = route($route . '.index');
    $args->createBreadcrumbAction = route($route . '.create');
    $args->createBreadcrumbName = 'Create';
    $args->breadcrumbTitle = ucwords(str_replace('-', ' ', $route));
    $args->tableColumn = 'id';
    $args->screenName = $route;
    $args->showCriticalPoints = false;
    return $args;
}

function getRouteArgsReports($route)
{
    $args = new AppClass();
    $args->breadcrumbName = 'List';
    $args->breadcrumbAction = $route;
    $args->breadcrumbTitle = ucwords(str_replace('-', ' ', $route));
    $args->screenName = $route;
    $args->dropDownDesign = true;
    $args->showCriticalPoints = false;
    $args->showTimeStamp = false;
    $args->tableColumn = 'id';
    return $args;
}

function getAppTypes()
{
    $appType = new AppClass();
    $appType->typeDelete = config('constants.TYPE_DELETE');
    $appType->typeInactive = config('constants.TYPE_INACTIVE');
    $appType->typeActive = config('constants.TYPE_ACTIVE');
    $appType->typeStatusUpdate = config('constants.TYPE_STATUS_UPDATE');
    return $appType;
}

function getMenuIdByRouteName()
{
    $getRoute = Route::currentRouteName();
    $routeName = explode('.', $getRoute);
    $name = $routeName[0];
    $menuMapping = config('constants.MENU_MAPPING');
    $return = new AppClass();
    $return->routeName = $name;
    $return->menuId = $menuMapping[$name];
    return $return;
}

function isMenuAccess($menuId = null)
{
    $routeDetails = getMenuIdByRouteName();
    $menuId = $menuId->toArray();
    if ($routeDetails->menuId && !in_array($routeDetails->menuId, $menuId)) {
        return true;
    }
}

function isElementHasValue($element, $key)
{
    return isset($element[$key]) ? strip_tags($element[$key]) : '';
}

function numberFormat($number, $round = 0)
{
    return number_format($number, $round);
}

function isElementHasValueObjectAndReturnZero($element, $key)
{
    return isset($element->$key) ? $element->$key : 0;
}

function AppDateTimeFormat($dateTime = null)
{
    if ($dateTime) {
        // $dateTime = getUserTimeZone($dateTime);
        return Carbon::parse($dateTime)->format('d-m-Y h:i A');
    }
}
function AppTimeFormat($dateTime = null)
{
    if ($dateTime) {
        // $dateTime = getUserTimeZone($dateTime);
        return Carbon::parse($dateTime)->format('H:i:s');
    }
}
function AppDateFormat($dateTime = null)
{
    return Carbon::parse($dateTime)->format('d-m-Y');
}
function isIssetValue($element, $key)
{
    return isset($element->$key) ? $element->$key : '';
}

function isIssetValueArray($element, $key)
{
    return isset($element[$key]) ? $element[$key] : '';
}

function formatString($string)
{
    return strtolower(trim($string));
}

function removeHtmlTags($string)
{
    $string = str_replace("&nbsp;", "", $string);
    return strip_tags($string);
}

function getUserTimeZone($dateTime = null)
{
    $date = Carbon::createFromFormat('Y-m-d H:i:s', $dateTime, 'UTC');
    $date->setTimezone('Asia/Kolkata');
    return $date;
}

function addCountryCodeToPhone($mobileNumber = null)
{
    if ($mobileNumber) {
        return '+91' . $mobileNumber;
    }
}

function appendFieldNameToName($jsonContent)
{
    $fieldType = $jsonContent['type'];
    switch ($fieldType) {
        case 'checkbox-group':
            $html = 'checkbox-group_' . $jsonContent['name'];
            break;
        case 'date':
            $html = 'date_' . $jsonContent['name'];
            break;
        case 'number':
            $html = 'number_' . $jsonContent['name'];
            break;
        case 'text':
            $html = 'text_' . $jsonContent['name'];
            break;
        case 'radio-group':
            $html = 'radio-group_' . $jsonContent['name'];
            break;
        case 'select':
            $html = 'select_' . $jsonContent['name'];
            break;
        case 'textarea':
            $html = 'textarea_' . $jsonContent['name'];
            break;
    }
    return $html;
}

function escalationLevelNames($level)
{
    if ($level) {
        $levelNames = ['AWC Worker', 'CDPO', 'DPO'];
        $index = $level - 1;
        return $levelNames[$index];
    }
}


function showRecordings()
{
    $roles = RoleMaster::RECORDING_HIDDEN_ROLES;
    if (in_array(Auth::user()->role, $roles)) {
        return false;
    } else {
        return true;
    }
}

function calcPercentage($value1 = null, $value2 = null)
{
    if ($value1 && $value2) {
        $answer = round($value1 / $value2 * 100);
        return $answer;
    }
}

function sendResponse($result, $message)
{
    $response = [
        'success' => true,
        'data'    => $result,
        'message' => $message,
    ];
    return response()->json($response, 200);
}

function sendError($error, $errorMessages = [], $code = 404)
{
    $response = [
        'success' => false,
        'message' => $error,
    ];

    if (!empty($errorMessages)) {
        $response['data'] = $errorMessages;
    }

    return response()->json($response, $code);
}

function getUserByToken(Request $request)
{
    $token = PersonalAccessToken::findToken($request->bearerToken());
    $user = $token->tokenable;
    return $user;
}

function formatMobileNo($mobile)
{
    if ($mobile) {
        $mobChar = substr($mobile, 0, 2);
        if (str_contains($mobChar, '91') && strlen($mobile) > 10) {
            $mobile = substr($mobile, 2, 10);
        }
    }
    return $mobile;
}

function returnZeroWhenEmptyOrNull($value)
{
    if (!$value > 0) {
        return 0;
    }
    return $value;
}

function pascalCase($string)
{
    $formatted = ucwords(str_replace('_', ' ', $string));
    return $formatted;
}

function timeFormatting($totalSeconds)
{
    if (!$totalSeconds) {
        return 0;
    }
    $minutes = floor($totalSeconds / 60);
    $seconds = $totalSeconds % 60;
    $formatted = sprintf("%02dm %02ds", $minutes, $seconds);
    return $formatted;
}
