<?php

namespace App\View\Components;

use App\Models\Masters\CallSkipReason;
use Illuminate\View\Component;

class CallreasonDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;
    private $id;
    private $name;

    public function __construct($selected = null, $label = true, $id = 'call_reason', $name = "call_reason")
    {
        $this->selected = $selected;
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $callReasons = CallSkipReason::whereStatus(CallSkipReason::STATUS_ACTIVE)->get();
        $id = $this->id;
        $label = $this->label;
        $selected = $this->selected;
        $name = $this->name;
        return view('components.callreason-drop-down', compact('callReasons', 'id', 'label', 'selected', 'name'));
    }
}
