<?php

namespace App\View\Components;

use App\Models\Masters\ClusterMaster;
use Illuminate\View\Component;

class ClusterDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;
    private $id;
    private $name;

    public function __construct($selected = null, $label = true, $id = 'cluster', $name = "cluster")
    {
        $this->selected = $selected;
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $clusters = ClusterMaster::whereStatus(ClusterMaster::STATUS_ACTIVE)->get();
        $id = $this->id;
        $label = $this->label;
        $selected = $this->selected;
        $name = $this->name;
        return view('components.cluster-drop-down', compact('clusters', 'id', 'label', 'selected', 'name'));
    }
}
