<?php

namespace App\View\Components;

use Illuminate\View\Component;

class DateRange extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */

    private $label;
    private $id;
    private $name;

    public function __construct($label = true, $id = 'date_range', $name = "dateRange")
    {
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $id = $this->id;
        $label = $this->label;
        $name = $this->name;
        return view('components.date-range', compact('id', 'label', 'name'));
    }
}
