<?php

namespace App\View\Components;

use App\Models\Transactions\BeneficiaryImport;
use Illuminate\View\Component;

class SourceDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;
    private $id;
    private $name;

    public function __construct($selected = null, $label = true, $id = 'source', $name = "source")
    {
        $this->selected = $selected ?? date('Y');
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {

        $id = $this->id;
        $label = $this->label;
        $selected = $this->selected;
        $name = $this->name;
        $sources = BeneficiaryImport::SOURCE_TYPE_DROP_DOWN;
        return view('components.source-drop-down', compact('sources', 'id', 'label', 'selected', 'name'));
    }
}
