<?php

namespace App\View\Components;

use Illuminate\View\Component;
use App\Models\Masters\StateMaster;

class StateDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;

    public function __construct($selected = null, $label = true)
    {
        $this->selected = $selected;
        $this->label = $label;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $selected = $this->selected;
        $label = $this->label;
        $states = StateMaster::where('status', StateMaster::STATUS_ACTIVE)->get();
        return view('components.state-drop-down', compact('states','selected','label'));
    }
}
