$(document).ready(function () {
    $(document).on("change", "#branch", function () {
        var productUrl = $("#productUrl").val();
        var agentUrl = $("#agentUrl").val();
        showLoader();
        $.ajax({
            url: productUrl,
            type: "POST",
            data: { branchId: $(this).val() },
            dataType: "json",
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            success: function (response) {
                $("#product").find("option").remove();
                if (response) {
                    $.each(response, function (key, value) {
                        $("#product").append(
                            `<option value="${value.description}">${value.description}</option>`
                        );
                    });
                }
                hideLoader();
            },
            error: function (jqXHR, exception) {
                hideLoader();
            },
        });

        getAgents(agentUrl, "");

        // $.ajax({
        //     url: agentUrl,
        //     type: "POST",
        //     data: { branchId: $(this).val() },
        //     dataType: "json",
        //     headers: {
        //         "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        //     },
        //     success: function (response) {
        //         $("#agent").find("option").remove();
        //         if (response) {
        //             $.each(response, function (key, value) {
        //                 $("#agent").append(
        //                     `<option value="${value.id}">${value.name}</option>`
        //                 );
        //             });
        //         }
        //         hideLoader();
        //     },
        //     error: function (jqXHR, exception) {
        //         hideLoader();
        //     },
        // });
    });

    $(document).on("click", ".getData", function () {
        if (!$("#branch").val()) {
            alert("select branch");
        } else {
            showLoader();
            var customerListUrl = $("#customerListUrl").val();
            var html = "";
            $.ajax({
                url: customerListUrl,
                type: "POST",
                data: {
                    products: $("#product").val(),
                    branchId: $("#branch").val(),
                },
                dataType: "json",
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr(
                        "content"
                    ),
                },
                success: function (response) {
                    if (response) {
                        $.each(response, function (key, value) {
                            html +=
                                "<tr>" +
                                "<td><label class='ckbox'><input class='childCheckBox' type='checkbox' name='customerId[][" +
                                value.id +
                                "]'><span></span></label></td>" +
                                "<td>" +
                                value.customer_name +
                                "</td>" +
                                "<td>" +
                                value.mobile_number +
                                "</td>" +
                                "<td>" +
                                value.date +
                                "</td>" +
                                "<td>" +
                                value.description +
                                "</td>" +
                                "</tr>";
                        });
                    }
                    $("#mapping-tbody").html(html);
                    hideLoader();
                },
                error: function (jqXHR, exception) {
                    hideLoader();
                },
            });
        }
    });

    $(".selectAll").click(function () {
        if ($(this).prop("checked")) {
            $(".childCheckBox").prop("checked", true);
        } else {
            $(".childCheckBox").prop("checked", false);
        }
    });

    $(".submitMapping").click(function () {
        if ($("#agent").val().length == 0) {
            alert("Select agent");
        } else if ($(".childCheckBox").filter(":checked").length == 0) {
            alert("Select any one customer and proceed");
        } else {
            $("#call-mapping-form").submit();
        }
    });
});
