$(document).ready(function () {

    getDashboardData();

    $(document).on('change', '.common-on-change', function () {
        var id = $(this).attr('id');
        if (id == 'scheme') {
            getPrograms('dashboard/get-programs-ajax', 'dashboard');
        }
        if (id == 'district') {
            getBlocks('dashboard/get-block-ajax', 'dashboard');
        }
        getDashboardData();
    });

});

function coreFilters() {

    var scheme = $('#scheme option:selected').val();
    var program = $('#program option:selected').val();
    var district = $('#district option:selected').val();
    var block = $('#block option:selected').val();
    var dateRange = $('#date_range').val();

    formData = {
        scheme: scheme,
        program: program,
        district: district,
        block: block,
        dateRange: dateRange
    }

    return formData;

}

function getDashboardData() {
    getDashboardCounts();
}

function commonAjax(formData) {
    $("#global-loader").show();
    var url = 'esc-dashboard-data';
    $.ajax({
        url: url,
        type: 'POST',
        data: formData,
        dataType: "json",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (response) {

            $(response.renderId).html(response.html);
            $("#global-loader").fadeOut("slow");

        },
        error: function (jqXHR, exception) {
            $("#global-loader").fadeOut("slow");
        },
    });
}

function getDashboardCounts() {
    var formData = coreFilters();
    formData.type = 'summary-counts';
    commonAjax(formData);
}




