//initialize Form Builder
$(function () {
    var fbEditor = document.getElementsByClassName('build-wrap');
    var formBuilder = $(fbEditor).formBuilder();

    var templates = $('#form_json').data('prototype');

    if (templates != '') {
        setTimeout(function () { formBuilder.actions.setData(templates); }, 1000);
    }

    $(document).on("click", ".other-options", function () {
        var id = $(this).data('field-id');
        $('#' + id).addClass('d-none');
        if ($(this).is(":checked")) {
            $('#' + id).removeClass('d-none');
        }
    });

    $(document).on("click", ".radio-select", function () {
        var id = $(this).data('field-id');
        $('#' + id).addClass('d-none');
    });
    
    $(".form-builder-submit").on('click', function (e) {
        e.preventDefault();
        $("#global-loader").show();
        if ($('#scheme option:selected').val() == '') {
            showToastr('Select Scheme', 'alert-warning');
        } else if ($('#program option:selected').val() == '') {
            showToastr('Select Program', 'alert-warning');
        } else {
            var formJson = formBuilder.actions.getData('json');
            var url = $(this).data('url');

            var formData = new FormData();
            formData.append("formJson", formJson);
            formData.append("schemeId", $('#scheme option:selected').val());
            formData.append("programId", $('#program option:selected').val());
            formData.append("uniqueId", $('#uniqueId').val());

            $.ajax({
                url: url,
                type: 'POST',
                data: formData,
                dataType: "json",
                cache: false,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: function (response) {
                    $("#global-loader").fadeOut("slow");
                    if (response.status) {
                        $('#success-modal-alert').find('.success-text').html(response.msg);
                        $('#success-modal-alert').modal('show');
                        $('#success-modal-alert').modal({ backdrop: 'static', keyboard: false });
                    } else {
                        $('#failure-modal-alert').find('.failure-text').html(response.msg);
                        $('#failure-modal-alert').modal('show');
                        $('#failure-modal-alert').modal({ backdrop: 'static', keyboard: false });
                    }

                },
                error: function (jqXHR, exception) {

                },
            });

        }

    });

});


