$(document).ready(function () {
    getDashboardData();

    $(document).on("change", ".common-on-change", function () {
        var id = $(this).attr("id");
        if (id == "scheme") {
            getPrograms("dashboard/get-programs-ajax", "dashboard");
        }
        if (id == "district") {
            getBlocks("dashboard/get-block-ajax", "dashboard");
        }
        getDashboardData();
    });
});

function getDashboardData() {
    getTotalCallsSummary();
    answeredComparisionChart();
    getProgramwiseCalls();
    getProgramwiseChart();
    getProgramwiseChartPercentage();
    getSeparateProgramwiseCalls();
    getDistrictwiseCalls();
    getMaximumFeedbackChart();
    getMaximumFeedbackChartPercentage();
    getMaximumComplaintsChart();
    getMaximumComplaintsChartPercentage();
    highComplaintsProgramwise();
    highComplaintsDistrictwiseData();
    categorywiseComplaints();
    topComplaintsDistricts();
    topComplaintsDistrictsPercentage();
    maxWrongNumbers();
    maxWrongNumbersPercentage();
    notAttendChart();
    notAttendChartPercentage();
    resolvedChart();
    resolvedChartPercentage();
    resolvedTable();
    reconnectedChart();
    reconnectedChartPercentage();
    reconnectedTable();
    complaintsComparision();
    complaintsComparisionTable();
    feedbackComparision();
    feedbackComparisionTable();
    //escalation dashboard
    getEscDashboardCounts();
    complaintsResolvedByWorker();
    districtwiseAvgTimeResolved();
}

function getEscDashboardCounts() {
    var formData = coreFilters();
    formData.type = "esc-dashboard-counts";
    formData.loaderId = "30";
    commonAjax(formData);
}

function complaintsResolvedByWorker() {
    var formData = coreFilters();
    formData.type = "complaints-resolved-by-worker";
    formData.loaderId = "31";
    commonAjaxCharts(formData, "bar-chart");
}

function coreFilters() {
    var scheme = $("#scheme option:selected").val();
    var program = $("#program option:selected").val();
    var district = $("#district option:selected").val();
    var block = $("#block option:selected").val();
    var dateRange = $("#date_range").val();

    formData = {
        scheme: scheme,
        program: program,
        district: district,
        block: block,
        dateRange: dateRange,
    };

    return formData;
}

function commonAjax(formData, tableId = null) {
    var url = "presentation-ajax";
    $.ajax({
        url: url,
        type: "POST",
        async: true,
        data: formData,
        dataType: "json",
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        beforeSend: function () {
            $("#global-loader-" + formData.loaderId).show();
        },
        complete: function () {
            $("#global-loader-" + formData.loaderId).fadeOut("slow");
        },
        success: function (response) {
            if (tableId) {
                drawDataTable(response, tableId);
            } else {
                $(response.renderId).html(response.html);
            }
        },
        error: function (jqXHR, exception) {},
    });
}

function drawDataTable(response, tableId) {
    if (tableId == "resolved_list_table") {
        drawResolvedTable(response, tableId);
    } else if (tableId == "reconnect_list_table") {
        drawReconnectedTable(response, tableId);
    } else if (tableId == "complaints_list_table") {
        drawComplaintsTable(response, tableId);
    } else if (tableId == "feedback_list_table") {
        drawFeedbackTable(response, tableId);
    } else if (tableId == "complaints_resolved_table") {
        drawResolvedComlaintsTable(response, tableId);
    }
}

function commonAjaxCharts(formData, type) {
    var url = "presentation-ajax";
    $.ajax({
        url: url,
        type: "POST",
        async: true,
        data: formData,
        dataType: "json",
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        beforeSend: function () {
            $("#global-loader-" + formData.loaderId).show();
        },
        complete: function () {
            $("#global-loader-" + formData.loaderId).fadeOut("slow");
        },
        success: function (response) {
            if (type == "bar-chart") {
                drawBasicBarChart(response);
            } else if (type == "rotation-bar-chart") {
                rotationBarchart(response);
            } else if (type == "stacked-bar-chart") {
                stackedBarchart(response);
            }
        },
        error: function (jqXHR, exception) {},
    });
}

function getTotalCallsSummary() {
    var formData = coreFilters();
    formData.type = "total-calls";
    formData.loaderId = "1";
    commonAjax(formData);
}

function getProgramwiseCalls() {
    var formData = coreFilters();
    formData.type = "program-wise-calls";
    formData.loaderId = "3";
    commonAjax(formData);
}

function getSeparateProgramwiseCalls() {
    var formData = coreFilters();
    formData.type = "separate-program-wise-calls";
    formData.loaderId = "6";
    commonAjax(formData);
}

function highComplaintsProgramwise() {
    var formData = coreFilters();
    formData.type = "high-complaints-program-wise";
    formData.loaderId = "12";
    commonAjax(formData);
}

function highComplaintsDistrictwiseData() {
    var formData = coreFilters();
    formData.type = "high-complaints-district-wise-data";
    formData.loaderId = "14";
    commonAjax(formData);
}

function categorywiseComplaints() {
    var formData = coreFilters();
    formData.type = "categorywise-complaints";
    formData.loaderId = "13";
    commonAjax(formData);
}

function drawBasicBarChart(response) {
    Highcharts.chart(response.renderId, {
        chart: {
            type: "column",
        },
        title: {
            text: response.title,
        },
        subtitle: {
            text: "",
        },
        xAxis: {
            categories: response.xaxisColumns,
            crosshair: true,
        },
        yAxis: {
            min: 0,
            title: {
                text: response.yaxisTitle,
            },
        },
        tooltip: {
            headerFormat:
                '<span style="font-size:10px">{point.key}</span><table>',
            pointFormat:
                '<tr><td style="color:{series.color};padding:0">{series.name}: </td>' +
                '<td style="padding:0"><b>{point.y:.0f}</b></td></tr>',
            footerFormat: "</table>",
            shared: true,
            useHTML: true,
        },
        plotOptions: {
            column: {
                pointPadding: 0.2,
                borderWidth: 0,
            },
        },
        series: response.series,
    });
}

function rotationBarchart(response) {
    Highcharts.chart(response.renderId, {
        chart: {
            type: "column",
        },
        title: {
            text: response.title,
        },
        subtitle: {
            text: "",
        },
        xAxis: {
            type: "category",
            labels: {
                rotation: -45,
                style: {
                    fontSize: "13px",
                    fontFamily: "Verdana, sans-serif",
                },
            },
        },
        yAxis: {
            min: 0,
            title: {
                text: response.yaxisTitle,
            },
        },
        legend: {
            enabled: false,
        },
        tooltip: {
            pointFormat: "<b>{point.y:.0f}</b>",
        },
        series: [
            {
                name: response.series.name,
                data: response.series.data,
                dataLabels: {
                    enabled: true,
                    rotation: -90,
                    color: "#FFFFFF",
                    align: "right",
                    format: "{point.y:.0f}",
                    y: 10,
                    style: {
                        fontSize: "13px",
                        fontFamily: "Verdana, sans-serif",
                    },
                },
            },
        ],
    });
}

function stackedBarchart(response) {
    Highcharts.chart(response.renderId, {
        chart: {
            type: "column",
        },
        title: {
            text: response.title,
            // align: 'center'
        },
        xAxis: {
            categories: response.xaxisColumns,
        },
        yAxis: {
            min: 0,
            title: {
                text: response.yaxisTitle,
            },
            stackLabels: {
                enabled: true,
                style: {
                    fontWeight: "bold",
                    color:
                        // theme
                        (Highcharts.defaultOptions.title.style &&
                            Highcharts.defaultOptions.title.style.color) ||
                        "gray",
                    textOutline: "none",
                },
            },
        },
        legend: {
            align: "left",
            x: 70,
            verticalAlign: "top",
            y: 70,
            floating: true,
            backgroundColor:
                Highcharts.defaultOptions.legend.backgroundColor || "white",
            borderColor: "#CCC",
            borderWidth: 1,
            shadow: false,
        },
        tooltip: {
            headerFormat: "<b>{point.x}</b><br/>",
            pointFormat:
                "{series.name}: {point.y}<br/>Total: {point.stackTotal}",
        },
        plotOptions: {
            column: {
                stacking: "normal",
                dataLabels: {
                    enabled: true,
                },
            },
        },
        series: response.series,
    });
}

function getProgramwiseChart() {
    var formData = coreFilters();
    formData.type = "programwise-chart";
    formData.loaderId = "4";
    commonAjaxCharts(formData, "bar-chart");
}

function answeredComparisionChart() {
    var formData = coreFilters();
    formData.type = "answered-comparision-chart";
    formData.loaderId = "2";
    commonAjaxCharts(formData, "bar-chart");
}

function unansweredComparisionChart() {
    var formData = coreFilters();
    formData.type = "unanswered-comparision-chart";
    commonAjaxCharts(formData, "bar-chart");
}

function getProgramwiseChartPercentage() {
    var formData = coreFilters();
    formData.type = "programwise-chart-percentage";
    formData.loaderId = "5";
    commonAjaxCharts(formData, "bar-chart");
}

function getMaximumFeedbackChart() {
    var formData = coreFilters();
    formData.type = "maximum-feedback-chart";
    formData.loaderId = "8";
    commonAjaxCharts(formData, "bar-chart");
}

function getMaximumFeedbackChartPercentage() {
    var formData = coreFilters();
    formData.type = "maximum-feedback-chart-percentage";
    formData.loaderId = "9";
    commonAjaxCharts(formData, "bar-chart");
}

function getMaximumComplaintsChart() {
    var formData = coreFilters();
    formData.type = "maximum-complaints-chart";
    formData.loaderId = "10";
    commonAjaxCharts(formData, "stacked-bar-chart");
}

function getMaximumComplaintsChartPercentage() {
    var formData = coreFilters();
    formData.type = "maximum-complaints-chart-percentage";
    formData.loaderId = "11";
    commonAjaxCharts(formData, "stacked-bar-chart");
}

function getDistrictwiseCalls() {
    var formData = coreFilters();
    formData.type = "districtwise-chart";
    formData.loaderId = "7";
    commonAjaxCharts(formData, "rotation-bar-chart");
}

function topComplaintsDistricts() {
    var formData = coreFilters();
    formData.type = "top-complaints-districts";
    formData.loaderId = "14";
    commonAjaxCharts(formData, "stacked-bar-chart");
}

function topComplaintsDistrictsPercentage() {
    var formData = coreFilters();
    formData.type = "top-complaints-districts-percentage";
    formData.loaderId = "15";
    commonAjaxCharts(formData, "bar-chart");
}

function maxWrongNumbers() {
    var formData = coreFilters();
    formData.type = "max-wrong-numbers";
    formData.loaderId = "16";
    commonAjaxCharts(formData, "stacked-bar-chart");
}

function maxWrongNumbersPercentage() {
    var formData = coreFilters();
    formData.type = "max-wrong-numbers-percentage";
    formData.loaderId = "17";
    commonAjaxCharts(formData, "bar-chart");
}

function notAttendChart() {
    var formData = coreFilters();
    formData.type = "not-attend";
    formData.loaderId = "18";
    commonAjaxCharts(formData, "bar-chart");
}

function notAttendChartPercentage() {
    var formData = coreFilters();
    formData.type = "not-attend-percentage";
    formData.loaderId = "19";
    commonAjaxCharts(formData, "bar-chart");
}

function resolvedChart() {
    var formData = coreFilters();
    formData.type = "resolved-charts";
    formData.loaderId = "20";
    commonAjaxCharts(formData, "bar-chart");
}

function resolvedChartPercentage() {
    var formData = coreFilters();
    formData.type = "resolved-charts-percentage";
    formData.loaderId = "21";
    commonAjaxCharts(formData, "bar-chart");
}

function resolvedTable() {
    var formData = coreFilters();
    formData.type = "resolved-table";
    formData.loaderId = "22";
    commonAjax(formData, "resolved_list_table");
}

function reconnectedTable() {
    var formData = coreFilters();
    formData.type = "reconnected-table";
    formData.loaderId = "25";
    commonAjax(formData, "reconnect_list_table");
}

function complaintsComparisionTable() {
    var formData = coreFilters();
    formData.type = "complaints-table";
    formData.loaderId = "27";
    commonAjax(formData, "complaints_list_table");
}

function districtwiseAvgTimeResolved() {
    var formData = coreFilters();
    formData.type = "districtwise-avg-time-resolved";
    formData.loaderId = "32";
    commonAjax(formData, "complaints_resolved_table");
}

function feedbackComparisionTable() {
    var formData = coreFilters();
    formData.type = "feedback-table";
    formData.loaderId = "29";
    commonAjax(formData, "feedback_list_table");
}

function reconnectedChart() {
    var formData = coreFilters();
    formData.type = "reconnected-charts";
    formData.loaderId = "23";
    commonAjaxCharts(formData, "bar-chart");
}

function reconnectedChartPercentage() {
    var formData = coreFilters();
    formData.type = "reconnected-charts-percentage";
    formData.loaderId = "24";
    commonAjaxCharts(formData, "bar-chart");
}

function complaintsComparision() {
    var formData = coreFilters();
    formData.type = "complaints-comparision";
    formData.loaderId = "26";
    commonAjaxCharts(formData, "bar-chart");
}

function feedbackComparision() {
    var formData = coreFilters();
    formData.type = "feedback-comparision";
    formData.loaderId = "28";
    commonAjaxCharts(formData, "bar-chart");
}

function drawResolvedTable(response, tableId) {
    var table =
        '<table class="table table-responsive" id="resolved_list_table">' +
        "<thead>" +
        "<tr>" +
        "<th>S.NO</th>" +
        "<th>District</th>" +
        "<th>Complaints</th>" +
        "<th>Resolved</th>" +
        "</tr>" +
        "</thead>" +
        "<tbody>";
    $.each(response, function (index, value) {
        table +=
            "<tr><td>" +
            (index + 1) +
            "</td>" +
            "<td>" +
            value.name +
            "</td>" +
            "<td>" +
            value.complaintsCount +
            "</td>" +
            "<td>" +
            value.count +
            "</td></tr>";
    });

    table += "</tbody></table>";

    $("#resolved_list").html(table);
    $("#" + tableId).DataTable();
}

function drawReconnectedTable(response, tableId) {
    var table =
        '<table class="table table-responsive" id="reconnect_list_table">' +
        "<thead>" +
        "<tr>" +
        "<th>S.NO</th>" +
        "<th>District</th>" +
        "<th>Total Calls</th>" +
        "<th>Feedback</th>" +
        "<th>Complaints</th>" +
        "</tr>" +
        "</thead>" +
        "<tbody>";
    $.each(response, function (index, value) {
        table +=
            "<tr>" +
            "<td>" +
            (index + 1) +
            "</td>" +
            "<td>" +
            value.name +
            "</td>" +
            "<td>" +
            value.totalCalls +
            "</td>" +
            "<td>" +
            value.feedbackCount +
            "</td>" +
            "<td>" +
            value.complaintCount +
            "</td>" +
            "</tr>";
    });

    table += "</tbody></table>";

    $("#reconnect_list").html(table);
    $("#" + tableId).DataTable();
}

function drawComplaintsTable(response, tableId) {
    var table =
        '<table class="table table-responsive" id="complaints_list_table">' +
        "<thead>" +
        "<tr>" +
        "<th>S.NO</th>" +
        "<th>District</th>";
    $.each(response.column, function (index, value) {
        table += "<th>" + value + "</th>";
    });
    table += "</tr>" + "</thead>" + "<tbody>";
    var sno = 1;
    $.each(response.rows, function (index, value) {
        table +=
            "<tr>" +
            "<td>" +
            sno++ +
            "</td>" +
            "<td>" +
            value.district +
            "</td>";
        $.each(value.month, function (index1, value1) {
            $.each(value1, function (index2, value2) {
                $.each(response.column, function (index3, value3) {
                    if (value3 == value2.monthName) {
                        table += "<td>" + value2.count + "</td>";
                    }
                });
            });
        });
        table += "</tr>";
    });

    table += "</tbody></table>";

    $("#complaints_list").html(table);
    $("#" + tableId).DataTable();
}

function drawResolvedComlaintsTable(response, tableId) {
    var table =
        '<table class="table table-responsive" id="complaints_resolved_table">' +
        "<thead>" +
        "<tr>" +
        "<th>S.NO</th>" +
        "<th>District</th>" +
        "<th>Resolved</th>" +
        "<th>Avg Time Resolve</th>" +
        "</tr>" +
        "</thead>" +
        "<tbody>";
    var sno = 1;
    $.each(response, function (index, value) {
        table +=
            "<tr>" +
            "<td>" +
            sno++ +
            "</td>" +
            "<td>" +
            value.districtName +
            "</td>" +
            "<td>" +
            value.resolvedComplaints +
            "</td>" +
            "<td>" +
            value.diff +
            " Days</td>" +
            "</tr>";
    });

    table += "</tbody></table>";

    $("#districtwise-avg-time-resolved").html(table);
    $("#" + tableId).DataTable();
}

function drawFeedbackTable(response, tableId) {
    var table =
        '<table class="table table-responsive" id="feedback_list_table">' +
        "<thead>" +
        "<tr>" +
        "<th>S.NO</th>" +
        "<th>District</th>";
    $.each(response.column, function (index, value) {
        table += "<th>" + value + "</th>";
    });
    table += "</tr>" + "</thead>" + "<tbody>";
    var sno = 1;
    $.each(response.rows, function (index, value) {
        table +=
            "<tr>" +
            "<td>" +
            sno++ +
            "</td>" +
            "<td>" +
            value.district +
            "</td>";
        $.each(value.month, function (index1, value1) {
            $.each(value1, function (index2, value2) {
                $.each(response.column, function (index3, value3) {
                    if (value3 == value2.monthName) {
                        table += "<td>" + value2.count + "</td>";
                    }
                });
            });
        });
        table += "</tr>";
    });

    table += "</tbody></table>";

    $("#feedback_list").html(table);
    $("#" + tableId).DataTable();
}
