$(document).ready(function () {
    $(document).on("click", ".delete-pending-calls", function (e) {
        e.preventDefault();
        var result = confirm("Are you sure you want to delete pending calls?");
        if (result) {
            showLoader();
            $.ajax({
                url: $("#delete-pending-calls-url").val(),
                type: "POST",
                data: {},
                dataType: "json",
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr(
                        "content"
                    ),
                },
                success: function (response) {
                    if (response.status) {
                        alert("pending calls deleted successfully");
                    } else {
                        alert("no pending calls to delete");
                    }
                    hideLoader();
                },
                error: function (jqXHR, exception) {
                    alert("failed to delete");
                    hideLoader();
                },
            });
        }
    });

    $(document).on("click", ".reallocate-calls", function (e) {
        e.preventDefault();
        var result = confirm("Are you sure you want to reallocate calls?");
        if (result) {
            showLoader();
            $.ajax({
                url: $("#reallocate-calls-url").val(),
                type: "POST",
                data: {},
                dataType: "json",
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr(
                        "content"
                    ),
                },
                success: function (response) {
                    if (response.status) {
                        alert("calls reallocated successfully");
                    } else {
                        alert("calls reallocated failed");
                    }
                    hideLoader();
                },
                error: function (jqXHR, exception) {
                    alert("failed to reallocate");
                    hideLoader();
                },
            });
        }
    });
});
