@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')
            <form target="_blank" class="form-horizontal" name="report-form" id="report-form" action="{{ $data->action }}"
                method="POST">
                @csrf
                @method($data->method)
                <div class="row">
                    <div class="col-md-3">
                        <label class="form-label">Date Range</label>
                        <x-date-range label="{{ false }}" />
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Branch</label>
                        <x-branch-drop-down label="{{ false }}" />
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Priority</label>
                        <x-priority-drop-down label="{{ false }}" />
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Source</label>
                        <x-ticket-source-drop-down label="{{ false }}" />
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Created By</label>
                        <x-users-drop-down label="{{ false }}" />
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Assigned To</label>
                        <x-agent-drop-down label="{{ false }}" />
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Category</label>
                        <x-ticket-category-drop-down label="{{ false }}" />
                    </div>
                    <div class="col-md-2">
                        <label class="form-label">Sub Department</label>
                        <x-sub-department-drop-down label="{{ false }}" />
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label class="form-label">Transfer Leads User</label>
                            <div class="parsley-select">
                                <select class="form-control select2 transferUser" name="transferUser" id="transferUser">
                                    <option label="Select Agent">
                                    </option>
                                    @foreach ($data->userList as $agent)
                                        <option value="{{ $agent->id }}">
                                            {{ $agent->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <div class="col-md-4 mt-4">
                        <button class="btn btn-success leadsActionBtn" data-type="transfer">Transfer Leads</button>
                        <button class="btn btn-warning leadsActionBtn" data-type="close">Close Tickets</button>
                        <button class="btn btn-primary downloadTickets">
                            <i class="fa fa-file-excel-o"></i>Excel
                        </button>
                    </div>
                </div>
                <div class="row row-sm">
                    <div class="col-lg-12">
                        <div class="card custom-card overflow-hidden">
                            <div class="card-body">

                                <div class="bg-gray-300 nav-bg">
                                    <nav class="nav nav-tabs">
                                        <a class="nav-link active" data-toggle="tab" href="#tabCont1">Active / Open</a>
                                        <a class="nav-link" data-toggle="tab" href="#tabCont2">WIP
                                        </a>
                                        <a class="nav-link" data-toggle="tab" href="#tabCont3">Closed
                                        </a>
                                        <a class="nav-link" data-toggle="tab" href="#tabCont4">All Tickets
                                        </a>
                                        <a class="nav-link" data-toggle="tab" href="#tabCont5">Drafts
                                        </a>
                                    </nav>
                                </div>

                                <div class="card-body tab-content">

                                    <div class="tab-pane active show" id="tabCont1">

                                        <div class="table-responsive">
                                            <table class="table active-datatable">
                                                <thead>
                                                    <tr>
                                                        <th class="wd-5p"><input type="checkbox" class="select-all"></th>
                                                        <th class="wd-20p">Ticket No</th>
                                                        <th class="wd-20p">Branch</th>
                                                        <th class="wd-20p">Name</th>
                                                        <th class="wd-20p">Phone</th>
                                                        <th class="wd-20p">Comment</th>
                                                        <th class="wd-20p">Category</th>
                                                        <th class="wd-20p">Expected Date</th>
                                                        <th class="wd-20p">Date Created</th>
                                                        <th class="wd-20p">Created By</th>
                                                        <th class="wd-20p">Assigned To</th>
                                                        <th class="wd-20p">File</th>
                                                        <th class="wd-20p">Read Status</th>
                                                        <th class="wd-20p">Lead Status</th>
                                                        <th class="wd-20p">Action</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="tab-pane" id="tabCont2">

                                        <div class="table-responsive">
                                            <table class="table wip-datatable">
                                                <thead>
                                                    <tr>
                                                        <th class="wd-5p"><input type="checkbox" class="select-all"></th>
                                                        <th class="wd-20p">Ticket No</th>
                                                        <th class="wd-20p">Branch</th>
                                                        <th class="wd-20p">Name</th>
                                                        <th class="wd-20p">Phone</th>
                                                        <th class="wd-20p">Comment</th>
                                                        <th class="wd-20p">Category</th>
                                                        <th class="wd-20p">Expected Date</th>
                                                        <th class="wd-20p">Date Created</th>
                                                        <th class="wd-20p">Created By</th>
                                                        <th class="wd-20p">Assigned To</th>
                                                        <th class="wd-20p">File</th>
                                                        <th class="wd-20p">Read Status</th>
                                                        <th class="wd-20p">Lead Status</th>
                                                        <th class="wd-20p">Action</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                    <div class="tab-pane" id="tabCont3">

                                        <div class="table-responsive">
                                            <table class="table closed-datatable">
                                                <thead>
                                                    <tr>
                                                        <th class="wd-5p"><input type="checkbox" class="select-all">
                                                        </th>
                                                        <th class="wd-20p">Ticket No</th>
                                                        <th class="wd-20p">Branch</th>
                                                        <th class="wd-20p">Name</th>
                                                        <th class="wd-20p">Phone</th>
                                                        <th class="wd-20p">Comment</th>
                                                        {{-- <th class="wd-20p">Reasons</th> --}}
                                                        <th class="wd-20p">Category</th>
                                                        <th class="wd-20p">Expected Date</th>
                                                        <th class="wd-20p">Date Created</th>
                                                        <th class="wd-20p">Created By</th>
                                                        <th class="wd-20p">Assigned To</th>
                                                        <th class="wd-20p">File</th>
                                                        <th class="wd-20p">Read Status</th>
                                                        <th class="wd-20p">Lead Status</th>
                                                        <th class="wd-20p">Action</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="tab-pane" id="tabCont4">

                                        <div class="table-responsive">
                                            <table class="table all-datatable">
                                                <thead>
                                                    <tr>
                                                        <th class="wd-5p"><input type="checkbox" class="select-all">
                                                        </th>
                                                        <th class="wd-20p">Ticket No</th>
                                                        <th class="wd-20p">Branch</th>
                                                        <th class="wd-20p">Name</th>
                                                        <th class="wd-20p">Phone</th>
                                                        <th class="wd-20p">Comment</th>
                                                        <th class="wd-20p">Category</th>
                                                        <th class="wd-20p">Expected Date</th>
                                                        <th class="wd-20p">Date Created</th>
                                                        <th class="wd-20p">Created By</th>
                                                        <th class="wd-20p">Assigned To</th>
                                                        <th class="wd-20p">File</th>
                                                        <th class="wd-20p">Read Status</th>
                                                        <th class="wd-20p">Lead Status</th>
                                                        <th class="wd-20p">Action</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>

                                    <div class="tab-pane" id="tabCont5">

                                        <div class="table-responsive">
                                            <table class="table draft-datatable">
                                                <thead>
                                                    <tr>
                                                        <th class="wd-5p"><input type="checkbox" class="select-all">
                                                        </th>
                                                        <th class="wd-20p">Ticket No</th>
                                                        <th class="wd-20p">Branch</th>
                                                        <th class="wd-20p">Name</th>
                                                        <th class="wd-20p">Phone</th>
                                                        <th class="wd-20p">Comment</th>
                                                        <th class="wd-20p">Category</th>
                                                        <th class="wd-20p">Expected Date</th>
                                                        <th class="wd-20p">Date Created</th>
                                                        <th class="wd-20p">Created By</th>
                                                        <th class="wd-20p">Assigned To</th>
                                                        <th class="wd-20p">File</th>
                                                        <th class="wd-20p">Read Status</th>
                                                        <th class="wd-20p">Lead Status</th>
                                                        <th class="wd-20p">Action</th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script type="text/javascript">
        $(function() {
            getActiveTableData(1, 'active-datatable');
        });

        $('.nav-tabs a').on('shown.bs.tab', function(e) {
            var targetTab = $(e.target).attr('href');
            $('.leadsActionBtn').show();
            switch (targetTab) {
                case '#tabCont1':
                    getActiveTableData(1, 'active-datatable');
                    break;
                case '#tabCont2':
                    getActiveTableData(2, 'wip-datatable');
                    break;
                case '#tabCont3':
                    $('.leadsActionBtn').hide();
                    getActiveTableData(3, 'closed-datatable');
                    break;
                case '#tabCont4':
                    $('.leadsActionBtn').hide();
                    getActiveTableData('all', 'all-datatable');
                    break;
                case '#tabCont5':
                    getActiveTableData(4, 'draft-datatable');
                    break;
            }
        });

        function getActiveTableData(status, className) {
            var tableSelector = $('.' + className);

            // Check if the DataTable is already initialized
            if ($.fn.DataTable.isDataTable(tableSelector)) {
                tableSelector.DataTable().clear().destroy(); // Destroy existing instance
            }

            // Initialize the DataTable
            tableSelector.DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('tickets.index') }}",
                    data: function(d) {
                        d.branch = $('#branch option:selected').val();
                        d.status = status;
                        d.dateRange = $('#date_range').val();
                        d.priority = $('#priority option:selected').val();
                        d.source = $('#source option:selected').val();
                        d.createdBy = $('#user option:selected').val();
                        d.agent = $('#agent option:selected').val();
                        d.category = $('#category option:selected').val();
                        d.department = $('#department option:selected').val();
                    }
                },
                columns: [
                    // {
                    //     data: 'DT_RowIndex',
                    //     name: 'DT_RowIndex',
                    //     orderable: false,
                    //     searchable: false
                    // },
                    {
                        data: "id",
                        render: function(data, type, row) {
                            return `<input type="checkbox" class="row-checkbox" value="${data}">`;
                        },
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'ticket_no',
                        name: 'ticket_no'
                    },
                    {
                        data: 'branchName',
                        name: 'branch_master.name'
                    },
                    {
                        data: 'customer_name',
                        name: 'customer_name'
                    },
                    {
                        data: 'mobile',
                        name: 'mobile'
                    },
                    {
                        data: 'wrapTxt',
                        name: 'ticket_comment'
                    },
                    // {
                    //     data: 'reason',
                    //     name: 'tickets_close_reason.name'
                    // },
                    {
                        data: 'ticketCategory',
                        name: 'ticket_category.name'
                    },
                    {
                        data: 'expectedDate',
                        name: 'expected_date'
                    },
                    {
                        data: 'formattedCreatedAt',
                        name: 'created_at'
                    },
                    {
                        data: 'createdUser',
                        name: 'users.name'
                    },
                    {
                        data: 'assignedUser',
                        name: 'agent_master.name'
                    },
                    {
                        data: 'downloadFile',
                        name: 'downloadFile',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'readStatus',
                        name: 'readStatus',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'lead_status',
                        name: 'lead_status',
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });
        }

        $(document).on('change', '.common-on-change', function() {
            // Find the currently active tab
            var activeTable = $('.tab-pane.active').find('table');

            if ($.fn.DataTable.isDataTable(activeTable)) {
                activeTable.DataTable().draw(); // Redraw the active table with updated filters
            }
        });

        $('.select-all').on('change', function() {
            var isChecked = this.checked;
            $('.row-checkbox').prop('checked', isChecked).trigger('change');
        });

        $('.leadsActionBtn').on('click', function() {
            var selectedIds = [];
            var type = $(this).data('type');
            $('.row-checkbox').each(function() {
                var rowId = $(this).val();
                if ($(this).prop('checked')) {
                    selectedIds.push(rowId);
                }
            });
            if (selectedIds.length == 0) {
                alert('select any one row and proceed');
            } else if (type == 'transfer' && !$('#transferUser').val()) {
                alert('select transfer leads user');
            } else {
                showLoader();
                formData = {
                    user: $('#transferUser').val(),
                    leads: selectedIds,
                    type: type
                };
                $.ajax({
                    url: "{{ route('transferCloseLeads') }}",
                    type: "POST",
                    data: formData,
                    dataType: "json",
                    headers: {
                        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                    },
                    success: function(response) {
                        hideLoader();
                        if (response.status == 'true') {
                            if (type == 'transfer') {
                                alert('tickets transfered successfully');
                            } else {
                                alert('tickets closed successfully');
                            }
                        } else {
                            alert('Failed contact admin');
                        }
                        location.reload();
                    },
                    error: function(jqXHR, exception) {
                        hideLoader();
                    },
                });
            }
        });
        $(document).on("click", ".downloadTickets", function() {
            var input = $("<input>")
                .attr("type", "hidden")
                .attr("name", "type")
                .val("tickets-report-excel");
            $("#report-form").append(input);
            $("#report-form").submit();
        });
    </script>
@endsection
