@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <input type="hidden" id="getSubDeptUrl" value="{{ route('getSubDept') }}">
            <div class="row">
                <div class="col-md-12">
                    <table class="table table-bordered">
                        <tbody>
                            <tr>
                                <td colspan="2">Ticket No : {{ $data->ticket_no }}</td>
                            </tr>
                            <tr>
                                <td>Customer Mobile No : {{ $data->mobile }}</td>
                                <td>Users : {{ $data->assignedUser }}</td>
                            </tr>
                            <tr>
                                <td>Secondary Mobile No : {{ $data->secondary_mobile }}</td>
                                <td>Ticket Source : {{ $data->ticketSource }}</td>
                            </tr>
                            <tr>
                                <td>Customer Name : {{ $data->customer_name }}</td>
                                <td>Ticket Type : {{ $data->ticketType }}</td>
                            </tr>
                            <tr>
                                <td>Email Address : {{ $data->email }}</td>
                                <td>Priority : {{ $data->priorityType }}</td>
                            </tr>
                            <tr>
                                <td>Location : {{ $data->location }}</td>
                                <td>Expected Date : {{ $data->expectedDate }}</td>
                            </tr>
                            <tr>
                                <td>Address : {{ $data->address }}</td>
                                <td>Expected Price : {{ $data->expected_price }}</td>
                            </tr>
                            <tr>
                                <td>Product Inquired For : {{ $data->productName }}</td>
                                <td>Offer Price : {{ $data->offer_price }}</td>
                            </tr>
                            <tr>
                                <td>Search by Request Category : {{ $data->requestCategory }}</td>
                                <td>Attachments : <a href="{{ $data->downloadUrl }}" target="_blank"><i
                                            class="fa fa-download attachment_icon"></i></a></td>
                            </tr>
                            <tr>
                                <td>Branch : {{ $data->branchName }}</td>
                                <td>Comments : {{ $data->ticket_comment }}</td>
                            </tr>
                            <tr>
                                <td>Sub Department : {{ $data->subDep }}</td>
                                <td>Closed Reason : {{ $data->reason }}</td>
                            </tr>
                            <tr>
                                <td>Ticket Category : {{ $data->ticketCategory }}</td>
                                <td>Ticket Status : {{ $data->status }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <form class="form-horizontal" name="tickets-form" id="tickets-form" action="{{ route('updateTicket') }}"
                data-parsley-validate="" method="POST">
                @csrf
                @method('POST')

                <div class="card custom-card">
                    <div class="card-body">
                        <div class="row row-sm">

                            <div class="col-lg-6 col-md-6">
                                <input type="hidden" value="{{ $data->id }}" name="crmId">
                                <x-branch-drop-down selected="{{ $data->branch_id }}" />

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Sub Department</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select">
                                                <select class="form-control select2" name="subDepartment"
                                                    id="subDepartment">
                                                    @foreach ($data->subDeptList as $dept)
                                                        <option value="{{ $dept->id }}"
                                                            @if ($dept->id == $data->department) {{ 'selected' }} @endif>
                                                            {{ $dept->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <x-ticket-category-drop-down selected="{{ $data->ticket_category }}" />

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Assign To</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select">
                                                <select class="form-control select2" name="users" id="users">
                                                    @foreach ($data->usersList as $user)
                                                        <option value="{{ $user->id }}"
                                                            @if ($user->id == $data->users) {{ 'selected' }} @endif>
                                                            {{ $user->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <x-priority-drop-down selected="{{ $data->priority }}" />

                            </div>

                            <div class="col-lg-6 col-md-6">

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Call Type</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select">
                                                <select class="form-control select2" name="callType" id="callType">
                                                    <option value="Answered">
                                                        Answered
                                                    </option>
                                                    <option value="Not Answered">
                                                        Not Answered
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Called For</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select">
                                                <select class="form-control select2" name="calledFor" id="calledFor">
                                                    <option value="Ticket Details">
                                                        Ticket Details
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Meeting / followup Date</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="mg-b-20">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <div class="input-group-text">
                                                            <i class="fe fe-calendar lh--9 op-6"></i>
                                                        </div>
                                                    </div><input class="form-control fc-datepicker-custom" type="text"
                                                        name="followupDate" value="">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Person Talked With</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="talkedWith" class="form-control" value="">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Ticket Status</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select">
                                                <select class="form-control select2" name="ticketStatus"
                                                    id="ticketStatus" required=""
                                                    data-parsley-required-message="Ticket Status"
                                                    data-parsley-class-handler="#ticketStatus"
                                                    data-parsley-errors-container="#ticketStatusErrorContainer">
                                                    <option label="Select Status">
                                                    </option>
                                                    <option value="1"
                                                        @if ($data->status == '1') selected="selected" @endif>
                                                        Open
                                                    </option>
                                                    <option value="2"
                                                        @if ($data->status == '2') selected="selected" @endif>
                                                        WIP
                                                    </option>
                                                    <option value="3"
                                                        @if ($data->status == '3') selected="selected" @endif>
                                                        Close
                                                    </option>
                                                </select>
                                                <div id="ticketStatusErrorContainer"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Comments</label>
                                        </div>
                                        <div class="col-md-9">
                                            <textarea class="form-control" name="comments" rows="3" required=""
                                                data-parsley-required-message="Comments is required"></textarea>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="row row-sm">
                                <div class="col-md-12">
                                    <a class="btn ripple btn-primary" href="{{ route('tickets.index') }}">
                                        <i class="fe fe-trash"></i> Cancel
                                    </a>
                                    <button class="btn ripple btn-success">
                                        <i class="fe fe-check-circle"></i> Submit
                                    </button>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('footerScripts')
    <script src="{{ URL::asset('js/tickets.js') }}?{{ appVersion() }}"></script>
@endsection
