@extends('templates.layout-external-links')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            <div class="row row-sm">
                <div class="col-lg-12 col-md-12">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="text-wrap">
                                <div class="example">
                                    <div class="border">
                                        <div class="bg-gray-300 nav-bg">
                                            <nav class="nav nav-tabs">
                                                <a class="nav-link active" data-toggle="tab" href="#tabCont1">Beneficiary
                                                    Details</a>
                                                <a class="nav-link" data-toggle="tab" href="#tabCont3">Complaint</a>
                                            </nav>
                                        </div>
                                        <div class="card-body tab-content">
                                            <div class="tab-pane active show" id="tabCont1">
                                                <div class="row">

                                                    <div class="col-md-6">
                                                        Feedback ID : {{ $data->feedback_no }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Scheme : {{ $data->scheme }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Program : {{ $data->program }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        District : {{ $data->district }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Block : {{ $data->block }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Sector : {{ $data->sector }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        AWC : {{ $data->awc }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Child Name : {{ $data->child_name }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Gender : {{ $data->gender }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Mobile : {{ $data->mobile_number }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Parent Name : {{ $data->parent_name }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Date Of Birth : {{ $data->date_of_birth }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Type : {{ $data->type }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Complaint Status : {{ $data->complain_status }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Complaint At Level : {{ $data->complain_level }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Resolved At Level : {{ $data->resolved_level }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Resolved At : {{ AppDateTimeFormat($data->resolved_at) }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Resolve Reason : {{ $data->resolve_reason }}
                                                    </div>
                                                    <div class="col-md-6">
                                                        Resolve Remarks : {{ $data->resolved_remarks }}
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="tab-pane" id="tabCont3">
                                                <div class="row">
                                                    @if (is_null($data->call_miss_reason))
                                                        @foreach ($data->feedback as $feedback)
                                                            @if ($data->is_compliant == 1 && $feedback->complaint != '' && $feedback->type != 'file')
                                                                <div class="col-md-12">
                                                                    <div class="row row-xs align-items-center mg-b-20">
                                                                        <div class="col-md-4">
                                                                            <label class="mg-b-0">{{ $feedback->label }} :
                                                                                <br>
                                                                                ({!! $feedback->value !!})
                                                                            </label>
                                                                        </div>
                                                                        <div class="col-md-8 mg-t-5 mg-md-t-0">
                                                                            {!! $feedback->complaint !!}
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            @endif
                                                        @endforeach
                                                    @endif
                                                </div>
                                            </div>

                                        </div>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
