@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            {{-- @include('transactions.feedback-filters') --}}

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table feedback-datatable custom-dt-style" id="feedback-datatable">
                                    <thead>
                                        <tr>
                                            {{-- <th class="wd-10p">Action</th> --}}
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-10p">Call At</th>
                                            <th class="wd-10p">Call User</th>
                                            <th class="wd-10p">Feedback ID</th>
                                            <th class="wd-10p">Customer Name</th>
                                            <th class="wd-10p">Mobile</th>
                                            <th class="wd-10p">Date</th>
                                            <th class="wd-10p">Description</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    <script type="text/javascript">
        $(function() {
            var table = $('.feedback-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('feedback.index') }}",
                    data: function(d) {
                        d.dateRange = $('#date_range').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [
                    // {
                    //     data: 'action',
                    //     name: 'action',
                    //     orderable: false,
                    //     searchable: false
                    // },
                    {
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'dateTime',
                        name: 'feedback.created_at'
                    },
                    {
                        data: 'createdUser',
                        name: 'users.name'
                    },
                    {
                        data: 'feedback_no',
                        name: 'feedback.feedback_no'
                    },
                    {
                        data: 'customer_name',
                        name: 'customer_name'
                    },
                    {
                        data: 'mobile_number',
                        name: 'mobile_number'
                    },
                    {
                        data: 'date',
                        name: 'invoice_date'
                    },
                    {
                        data: 'description',
                        name: 'description'
                    }
                ]
            });

            $(document).on('change', '.common-on-change', function() {
                table.draw();
            });

        });
    </script>
@endsection
