@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12 col-md-12">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="text-wrap">
                                <div class="example">
                                    <div class="border">
                                        <div class="bg-gray-300 nav-bg">
                                            <nav class="nav nav-tabs">
                                                <a class="nav-link" data-toggle="tab" href="#tabCont2">Feedback</a>
                                                <a class="nav-link" data-toggle="tab" href="#tabCont4">Call Details</a>
                                            </nav>
                                        </div>
                                        <div class="card-body tab-content">
                                            <div class="tab-pane active show" id="tabCont2">
                                                <div class="row">
                                                    <table class="table table-bordered">
                                                        <tbody>
                                                            <tr>
                                                                <td><b>Feedback ID : </b></td>
                                                                <td>{{ $data->feedback_no }}</td>
                                                                <td><b>Customer Name : </b></td>
                                                                <td>{{ $data->customer_name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td><b>Mobile : </b></td>
                                                                <td>{{ $data->mobile_number }}</td>
                                                                <td><b>Description : </b></td>
                                                                <td>{{ $data->description }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td><b>Date : </b></td>
                                                                <td>{{ AppDateFormat($data->invoice_date) }}</td>
                                                                <td><b>Agent : </b></td>
                                                                <td>{{ $data->createdUser }}</td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                            <div class="tab-pane" id="tabCont4">
                                                <div class="row">
                                                    <div class="col-md-12 table-responsive">
                                                        <table class="table table-bordered">
                                                            <thead>
                                                                <tr>
                                                                    <td>S.No</td>
                                                                    <td>Remarks</td>
                                                                    <td>Skip Reason</td>
                                                                    <td>Skip Reason Remarks</td>
                                                                    <td>Created</td>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach ($data->feedback as $key => $item)
                                                                    <tr>
                                                                        <td>{{ $key + 1 }}</td>
                                                                        <td>{{ $item->remarks }}</td>
                                                                        <td>{{ $item->skipReason }}</td>
                                                                        <td>{{ $item->call_skip_remarks }}</td>
                                                                        <td>{{ AppDateTimeFormat($item->created_at) }}</td>
                                                                    </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('footerScripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
@endsection
