@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12 col-md-12">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="row">
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <td><b>Name : </b></td>
                                            <td>{{ $data->name }}</td>
                                            <td><b>Code : </b></td>
                                            <td>{{ $data->code }}</td>
                                        </tr>
                                        <tr>
                                            <td><b>CRM Code : </b></td>
                                            <td>{{ $data->crm_code }}</td>
                                            <td><b>Justdial Code : </b></td>
                                            <td>{{ $data->justdial_code }}</td>
                                        </tr>
                                        <tr>
                                            <td><b>SAP Code : </b></td>
                                            <td>{{ $data->sap_code }}</td>
                                            <td><b>Address : </b></td>
                                            <td>{{ $data->address }}</td>
                                        </tr>
                                        <tr>
                                            <td><b>Pincode : </b></td>
                                            <td>{{ $data->pincode }}</td>
                                            <td><b>Calls Per User : </b></td>
                                            <td>{{ $data->calls_per_user }}</td>
                                        </tr>
                                        <tr>
                                            <td><b>Excel Campaign Code : </b></td>
                                            <td>{{ $data->excel_campaign_code }}</td>
                                            <td><b>Latitude : </b></td>
                                            <td>{{ $data->latitude }}</td>
                                        </tr>
                                        <tr>
                                            <td><b>Longitude : </b></td>
                                            <td>{{ $data->longitude }}</td>
                                            <td><b>Allow Login Distance : <small>(In Mtrs)</small></b></td>
                                            <td>{{ $data->allow_login_distance }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="row">
                                <div class="col-md-8">
                                    <h5>Lead Mapping</h5>
                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>S.No</th>
                                                <th>Name</th>
                                                <th>User ID</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($data->mapping as $key => $value)
                                                <tr>
                                                    <td>{{ $key + 1 }}</td>
                                                    <td>{{ $value->name }}</td>
                                                    <td>{{ $value->email }}</td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
