@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-8 col-md-8">
                    <div class="card custom-card">
                        <div class="card-body">

                            <form class="form-horizontal" name="user-form" id="user-form" action="{{ $data->route }}"
                                data-parsley-validate="" method="POST" enctype="multipart/form-data">
                                @csrf
                                @method($data->method)
                                <div class="form-group ">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Name</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="name" class="form-control"
                                                value="{{ $data->name }}" required=""
                                                data-parsley-required-message="Name is required">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group ">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Code</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="code" class="form-control"
                                                value="{{ $data->code }}" required=""
                                                data-parsley-required-message="Code is required">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group ">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Phone</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="number" name="phone" class="form-control"
                                                value="{{ $data->phone }}" required=""
                                                data-parsley-required-message="Phone is required">
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Branch</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select">
                                                <select class="form-control select2 common-on-change" required="" name="single_branch"
                                                    id="single_branch" data-parsley-required-message="Select a single branch"
                                                    data-parsley-class-handler="#singleBranch" data-parsley-errors-container="#singleBranchErrorContainer">
                                                    <option label="Select Single Branch">
                                                    </option>
                                                    @foreach ($data->branches as $branch)
                                                        <option value="{{ $branch->id }}"
                                                            @if ($branch->id == $data->branch) selected @endif>
                                                            {{ $branch->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <div id="singleBranchErrorContainer"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">User ID</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="email" id="email" class="form-control"
                                                   value="{{ $data->email }}" required=""
                                                   data-parsley-required-message="UserId is required"
                                                   data-parsley-trigger="focusout"
                                                   data-parsley-checkemail
                                                   data-parsley-checkemail-message="UserID already exists"
                                                   @if (isset($data->id)) readonly @endif>
                                
                                            <input type="hidden" value="{{ isset($data->userId) ? $data->userId : '' }}"
                                                   id="userId" name="userId">
                                            <input type="hidden" value="{{ isset($data->id) ? $data->id : '' }}"
                                                   id="clusterId" name="clusterId">
                                        </div>
                                    </div>
                                </div>
                                @if (!isset($data->id))
                                    <div class="form-group ">
                                        <div class="row row-sm">
                                            <div class="col-md-3">
                                                <label class="form-label">Password</label>
                                            </div>
                                            <div class="col-md-9">
                                                <input type="password" name="password" id="password" class="form-control"
                                                    value="" required=""
                                                    data-parsley-required-message="Password is required">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="row row-sm">
                                            <div class="col-md-3">
                                                <label class="form-label">Confirm Password</label>
                                            </div>
                                            <div class="col-md-9">
                                                <input type="password" name="ConfirmPassword" class="form-control"
                                                    value="" required=""
                                                    data-parsley-required-message="Confirm Password is required"
                                                    data-parsley-equalto="#password"
                                                    data-parsley-equalto-message="Password and confirm password must be same">
                                            </div>
                                        </div>
                                    </div>
                                @endif

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Branch Mapping</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select" id="branch">
                                                <select class="form-control select2" required="" name="branch[]" multiple
                                                    data-parsley-required-message="Select Branch"
                                                    data-parsley-class-handler="#branch"
                                                    data-parsley-errors-container="#branchErrorContainer">
                                                    <option label="Select Branch"></option>
                                                    <?php $__currentLoopData = $data->branchList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($branch->id); ?>"
                                                            <?php if(isset($data->id) && in_array($branch->id, $data->selectedBranches)): ?> selected <?php endif; ?>>
                                                            <?php echo e($branch->name); ?>
                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <div id="branchErrorContainer"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                 
                                

                                {{-- <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Branch</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select" id="branch">
                                                <select class="form-control select2" required="" name="branch[]" multiple
                                                    data-parsley-required-message="Select Branch"
                                                    data-parsley-class-handler="#branch"
                                                    data-parsley-errors-container="#branchErrorContainer">
                                                    <option label="Select Branch">
                                                    </option>
                                                    @foreach ($data->branchList as $branch)
                                                        <option value="{{ $branch->id }}"
                                                            @if (isset($data->id) && in_array($branch->id, $data->branches)) {{ 'selected' }} @endif>
                                                            {{ $branch->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                <div id="branchErrorContainer"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div> --}}

                               


                                {{-- <x-role-drop-down selected="{{ $data->role }}"/> --}}



                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">

                                        </div>
                                        <div class="col-md-9">
                                            <button class="btn ripple btn-success">
                                                @if (isset($data->id))
                                                    <i class="fe fe-edit"></i> Update
                                                @else
                                                    <i class="fe fe-check-circle"></i> Submit
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    <script src="{{ URL::asset('js/masters/cluster.js') }}?{{ appVersion() }}"></script>
@endsection
