@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection

@section('content')
    <style>
        .dark-theme .nav-tabs .nav-link {
            font-size: 12px;
        }
    </style>
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb-reports', [
                'export' => true,
                'class' => 'downloadReport',
            ])

            @include('report_filters', [
                'dateFilter' => true,
                'branch' => true,
                'agent' => true,
            ])

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive border userlist-table">
                                <table
                                    class="table card-table custom-dt-style table-striped table-vcenter text-nowrap mb-0 agentwise-calls-datatable"
                                    style="width: 100%">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Branch</th>
                                            <th class="wd-20p">Agent</th>
                                            <th class="wd-20p">Designation</th>
                                            <th class="wd-20p">Allocated Calls</th>
                                            <th class="wd-20p">Dialled Calls</th>
                                            <th class="wd-20p">Connected Calls</th>
                                            <th class="wd-20p">Not Connected Calls</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    <script type="text/javascript">
        $(function() {

            var table1 = $('.agentwise-calls-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('agentwise-calls') }}",
                    data: function(d) {
                        d.branch = $('#branch option:selected').val(),
                        d.agent = $('#agent option:selected').val(),
                            d.dateRange = $('#date_range').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'branchName',
                        name: 'branch_master.name'
                    },
                    {
                        data: 'agentName',
                        name: 'agent_master.name',
                    },
                    {
                        data: 'designation',
                        name: 'designation_master.name',
                    },
                    {
                        data: 'allocatedCalls',
                        name: 'allocatedCalls',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'dialledCalls',
                        name: 'dialledCalls',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'connectedCalls',
                        name: 'connectedCalls',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'notConnectedCalls',
                        name: 'notConnectedCalls',
                        orderable: false,
                        searchable: false
                    }
                ]

            });

            $(document).on('change', '.common-on-change', function() {
                table1.draw();
            });

            $(document).on("click", ".downloadReport", function() {
                var input = $("<input>")
                    .attr("type", "hidden")
                    .attr("name", "type")
                    .val("agentwise-calls-report-excel");
                $("#report-form").append(input);
                $("#report-form").submit();
            });

        });
    </script>
@endsection
