@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection

@section('content')
    <style>
        .dark-theme .nav-tabs .nav-link {
            font-size: 12px;
        }
    </style>
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">

                <div class="col-md-3">
                    <label class="form-label">Date Range</label>
                    <div class="form-group">
                        <div class="row row-sm">
                            <div class="col-lg-12">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <div class="input-group-text">
                                            <i class="fe fe-calendar  lh--9 op-6"></i>
                                        </div>
                                    </div><input type="text" class="form-control pull-right common-on-change"
                                        id="date_range">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Branch</label>
                    <x-branch-drop-down label="{{ false }}" />
                </div>
                <div class="col-md-3">
                    <label class="form-label">Agent</label>
                    <x-agent-drop-down label="{{ false }}" />
                </div>
            </div>

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive border userlist-table">
                                <table
                                    class="table card-table custom-dt-style table-striped table-vcenter text-nowrap mb-0 calllog-datatable"
                                    style="width: 100%">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Branch</th>
                                            <th class="wd-20p">Agent Name</th>
                                            <th class="wd-20p">Customer Name</th>
                                            <th class="wd-20p">Customer Mobile</th>
                                            <th class="wd-20p">Call Date</th>
                                            <th class="wd-20p">Duration</th>
                                            <th class="wd-10p">Call Type</th>
                                            <th class="wd-10p">Recordings</th>
                                            <th class="wd-10p">Remarks</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script type="text/javascript">
        $(function() {

            var table1 = $('.calllog-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('call-logs') }}",
                    data: function(d) {
                        d.agent = $('#agent option:selected').val(),
                            d.branch = $('#branch option:selected').val(),
                            d.dateRange = $('#date_range').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'branchName',
                        name: 'branch_master.name'
                    },
                    {
                        data: 'agentName',
                        name: 'agent_master.name'
                    },
                    {
                        data: 'customer_name',
                        name: 'beneficiary_import.customer_name'
                    },
                    {
                        data: 'customer_mobile',
                        name: 'users_call_logs.customer_mobile'
                    },
                    {
                        data: 'callDate',
                        name: 'users_call_logs.call_date_time'
                    },
                    {
                        data: 'call_duration',
                        name: 'users_call_logs.call_duration'
                    },
                    {
                        data: 'call_type',
                        name: 'users_call_logs.call_type',
                    },
                    {
                        data: 'downloadRecordings',
                        name: 'downloadRecordings',
                    },
                    {
                        data: 'remarks',
                        name: 'users_call_logs.call_type',
                    },
                ],
                fnDrawCallback: function() {
                    var totalCount = this.api().page.info().recordsTotal;
                    $('#callback_count').html(totalCount);
                }

            });

            $(document).on('change', '.common-on-change', function() {
                table1.draw();
            });

            $('.datetimepicker').datetimepicker();

        });
    </script>
@endsection
