@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection

@section('content')
    <style>
        .dark-theme .nav-tabs .nav-link {
            font-size: 12px;
        }

        /* .dataTables_filter,
                        .dataTables_info {
                            display: none;
                        } */
    </style>
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb-reports', [
                'export' => true,
                'class' => 'downloadCallsDialled',
            ])

            @include('report_filters', [
                'dateFilter' => true,
                'branch' => true,
                'agent' => true,
                'cluster' => true,
                'source' => true,
            ])

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive border userlist-table">
                                <table
                                    class="table card-table custom-dt-style table-striped table-vcenter text-nowrap mb-0 calldialled-datatable"
                                    style="width: 100%">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">Action</th>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Source</th>
                                            <th class="wd-20p">Percentage</th>
                                            <th class="wd-20p">Recording</th>
                                            <th class="wd-20p">Ticket No</th>
                                            <th class="wd-20p">Cluster</th>
                                            <th class="wd-20p">Branch</th>
                                            <th class="wd-20p">Date</th>
                                            <th class="wd-20p">Agent Name</th>
                                            <th class="wd-20p">Designation</th>
                                            <th class="wd-20p">Class</th>
                                            <th class="wd-20p">Employee ID</th>
                                            <th class="wd-20p">Attendance</th>
                                            <th class="wd-20p">Login Time</th>
                                            <th class="wd-10p">Logout Time</th>
                                            <th class="wd-10p">Campaign Name</th>
                                            <th class="wd-10p">Date</th>
                                            <th class="wd-10p">Customer Name</th>
                                            <th class="wd-10p">Mobile No</th>
                                            <th class="wd-10p">Description</th>
                                            <th class="wd-10p">Call Date Time</th>
                                            <th class="wd-10p">Call Duration</th>
                                            <th class="wd-10p">Talk Duration</th>
                                            <th class="wd-10p">ACW</th>
                                            <th class="wd-10p">Disposition 1</th>
                                            <th class="wd-10p">Disposition 2</th>
                                            <th class="wd-10p">Disposition 3</th>
                                            <th class="wd-10p">Callback Date</th>
                                            <th class="wd-10p">Callback Time</th>
                                        </tr>
                                    </thead>
                                    <tfoot>
                                        <tr>
                                            <th>Action</th>
                                            <th>S.No</th>
                                            <th>Source</th>
                                            <th>Percentage</th>
                                            <th>Recording</th>
                                            <th>Ticket No</th>
                                            <th>Cluster</th>
                                            <th>Branch</th>
                                            <th>Date</th>
                                            <th>Agent Name</th>
                                            <th>Designation</th>
                                            <th>Class</th>
                                            <th>Employee ID</th>
                                            <th>Attendance</th>
                                            <th>Login Time</th>
                                            <th>Logout Time</th>
                                            <th>Campaign Name</th>
                                            <th>Date</th>
                                            <th>Customer Name</th>
                                            <th>Mobile No</th>
                                            <th>Description</th>
                                            <th>Call Date Time</th>
                                            <th>Call Duration</th>
                                            <th>Talk Duration</th>
                                            <th>ACW</th>
                                            <th>Disposition 1</th>
                                            <th>Disposition 2</th>
                                            <th>Disposition 3</th>
                                            <th>Callback Date</th>
                                            <th>Callback Time</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    <script type="text/javascript">
        $(function() {

            var table1 = $('.calldialled-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('calls-dialled') }}",
                    data: function(d) {
                        d.agent = $('#agent option:selected').val(),
                            d.branch = $('#branch option:selected').val(),
                            d.dateRange = $('#date_range').val(),
                            d.cluster = $('#cluster').val(),
                            d.source = $('#source').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'source',
                        name: 'source',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'percentage',
                        name: 'percentage',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'downloadRecordings',
                        name: 'downloadRecordings',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'ticketNo',
                        name: 'crm_tickets.ticket_no',
                    },
                    {
                        data: 'clusterName',
                        name: 'cluster_master.name',
                        orderable: false,
                    },
                    {
                        data: 'branchName',
                        name: 'branch_master.name',
                        orderable: false,
                    },
                    {
                        data: 'callDate',
                        name: 'callDate',
                        orderable: false,
                    },
                    {
                        data: 'agentName',
                        name: 'agent_master.name',
                        orderable: false,
                    },
                    {
                        data: 'designationName',
                        name: 'designation_master.name',
                        orderable: false,
                    },
                    {
                        data: 'className',
                        name: 'class_master.name',
                        orderable: false,
                    },
                    {
                        data: 'agentId',
                        name: 'agent_master.emp_no',
                        orderable: false,
                    },
                    {
                        data: 'attendance',
                        name: 'attendance',
                        orderable: false
                    },
                    {
                        data: 'login_in',
                        name: 'agents_login.login_in',
                        orderable: false
                    },
                    {
                        data: 'log_out',
                        name: 'agents_login.log_out',
                        orderable: false
                    },
                    {
                        data: 'campaignName',
                        name: 'campaign.title',
                        orderable: false
                    },
                    {
                        data: 'campaignDate',
                        name: 'campaignDate',
                        orderable: false,
                    },
                    {
                        data: 'customer_name',
                        name: 'beneficiary_import.customer_name',
                        orderable: false
                    },
                    {
                        data: 'mobile_number',
                        name: 'beneficiary_import.mobile_number',
                        orderable: false
                    },
                    {
                        data: 'description',
                        name: 'beneficiary_import.description',
                        orderable: false
                    },
                    {
                        data: 'callDateTime',
                        name: 'callDateTime',
                        orderable: false,
                    },
                    {
                        data: 'call_duration',
                        name: 'call_history.call_duration',
                        orderable: false
                    },
                    {
                        data: 'call_transfer_duration',
                        name: 'call_history.call_transfer_duration',
                        orderable: false
                    },
                    {
                        data: 'acw',
                        name: 'acw',
                        orderable: false
                    },
                    {
                        data: 'callStatus',
                        name: 'callStatus',
                        orderable: false
                    },
                    {
                        data: 'dispositions',
                        name: 'call_skip_reason.dispositions',
                        orderable: false
                    },
                    {
                        data: 'callReason',
                        name: 'call_skip_reason.name',
                        orderable: false
                    },
                    {
                        data: 'callbackDate',
                        name: 'callbackDate',
                        orderable: false,
                    },
                    {
                        data: 'callbackTime',
                        name: 'callbackTime',
                        orderable: false,
                    },
                ],
                initComplete: function() {
                    // updateFilters(table1);
                },
                drawCallback: function() {
                    updateFilters(table1);
                }
            });

            $(document).on('change', '.common-on-change', function() {
                table1.draw();
            });

            function updateFilters(table) {
                table.columns().every(function() {
                    var column = this;
                    var columnHeader = $(column.header());

                    // Find the select element for the column filter
                    var select = columnHeader.find('select');
                    if (select.length === 0) {
                        // Create new select if it doesn't exist
                        select = $(
                                '<br><select style="height: 30px;" class="form-control select2 filter-dt"><option value="">All</option></select>'
                            )
                            .appendTo(columnHeader)
                            .on('change', function() {
                                var val = $.fn.dataTable.util.escapeRegex($(this).val());
                                column.search(val ? '^' + val + '$' : '', true, false).draw();
                            });
                    }

                    // Get existing options and create a map for quick lookup
                    var existingOptions = {};
                    select.find('option').each(function() {
                        existingOptions[$(this).val()] = true;
                    });

                    // Add new options
                    column.data().unique().sort().each(function(d) {
                        if (d !== null && d !== undefined && !existingOptions[d]) {
                            select.append('<option value="' + d + '">' + d + '</option>');
                        }
                    });

                    $(column.footer()).empty();
                    $('.filter-dt').select2();

                });
            }



        });
    </script>
@endsection
