@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection

@section('content')
    <style>
        .dark-theme .nav-tabs .nav-link {
            font-size: 12px;
        }

        .crm-tickets-datatable td:nth-child(19) {
            white-space: normal;
            word-wrap: break-word;
            word-break: break-all;
        }
    </style>
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb-reports', [
                'export' => true,
                'class' => 'downloadCRMReport',
            ])

            @include('report_filters', [
                'dateFilter' => true,
                'branch' => true,
                'cluster' => true,
            ])

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive border userlist-table">
                                <table
                                    class="table card-table custom-dt-style table-striped table-vcenter text-nowrap mb-0 crm-tickets-datatable"
                                    style="width: 100%">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Cluster</th>
                                            <th class="wd-20p">Branch</th>
                                            <th class="wd-20p">Date</th>
                                            <th class="wd-20p">Name</th>
                                            <th class="wd-20p">Mobile</th>
                                            <th class="wd-20p">Email</th>
                                            <th class="wd-20p">Location</th>
                                            <th class="wd-20p">Product Enquired</th>
                                            <th class="wd-20p">Department</th>
                                            <th class="wd-20p">Category</th>
                                            <th class="wd-20p">Users</th>
                                            <th class="wd-20p">Source</th>
                                            <th class="wd-20p">Type</th>
                                            <th class="wd-20p">Priority</th>
                                            <th class="wd-20p">Expected Date</th>
                                            <th class="wd-20p">Expected Price</th>
                                            <th class="wd-20p">Offer Price</th>
                                            <th class="wd-20p">Read Status</th>
                                            <th class="wd-20p">Comment</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    <script src="{{ URL::asset('js/crm-ticket.js') }}?{{ appVersion() }}"></script>
    <script type="text/javascript">
        $(function() {

            var table1 = $('.crm-tickets-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('crm-tickets') }}",
                    data: function(d) {
                        d.branch = $('#branch option:selected').val(),
                            d.dateRange = $('#date_range').val(),
                            d.cluster = $('#cluster').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'clusterName',
                        name: 'cluster_master.name'
                    },
                    {
                        data: 'branchName',
                        name: 'branch_master.name'
                    },
                    {
                        data: 'dateTime',
                        name: 'dateTime',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'customer_name',
                        name: 'customer_name'
                    },
                    {
                        data: 'mobile',
                        name: 'mobile'
                    },
                    {
                        data: 'email',
                        name: 'email'
                    },
                    {
                        data: 'location',
                        name: 'location'
                    },
                    {
                        data: 'product_enquiry',
                        name: 'product_enquiry'
                    },
                    {
                        data: 'department',
                        name: 'department'
                    },
                    {
                        data: 'ticket_category',
                        name: 'ticket_category'
                    },
                    {
                        data: 'users',
                        name: 'users'
                    },
                    {
                        data: 'ticket_source',
                        name: 'ticket_source'
                    },
                    {
                        data: 'ticket_type',
                        name: 'ticket_type'
                    },
                    {
                        data: 'priority',
                        name: 'priority'
                    },
                    {
                        data: 'expectedDate',
                        name: 'expected_date'
                    },
                    {
                        data: 'expected_price',
                        name: 'expected_price'
                    },
                    {
                        data: 'offer_price',
                        name: 'offer_price'
                    },
                    {
                        data: 'readStatus',
                        name: 'readStatus',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'ticket_comment',
                        name: 'ticket_comment'
                    }
                ]

            });

            $(document).on('change', '.common-on-change', function() {
                table1.draw();
            });

        });
    </script>
@endsection
