@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection

@section('content')
    <style>
        .dark-theme .nav-tabs .nav-link {
            font-size: 12px;
        }

        .just-dial-leads-datatable td:nth-child(11) {
            white-space: normal;
            word-wrap: break-word;
            word-break: break-all;
        }
    </style>
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb-reports', [
                'export' => true,
                'class' => 'downloadJustDialReport',
            ])

            @include('report_filters', [
                'dateFilter' => true,
                'branch' => true,
                'cluster' => true,
            ])

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive border userlist-table">
                                <table
                                    class="table card-table custom-dt-style table-striped table-vcenter text-nowrap mb-0 just-dial-leads-datatable"
                                    style="width: 100%">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Cluster</th>
                                            <th class="wd-20p">Branch</th>
                                            <th class="wd-20p">Date</th>
                                            <th class="wd-20p">Name</th>
                                            <th class="wd-20p">Mobile</th>
                                            <th class="wd-20p">Email</th>
                                            <th class="wd-20p">Category</th>
                                            <th class="wd-20p">City</th>
                                            <th class="wd-20p">Area</th>
                                            <th class="wd-20p">Branch Area</th>
                                            <th class="wd-20p">Remarks</th>
                                            <th class="wd-20p">Read Status</th>
                                            <th class="wd-20p">Status</th>
                                            <th class="wd-20p">Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    @include('reports.leads-update-modal')
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    <script src="{{ URL::asset('js/just-dial.js') }}?{{ appVersion() }}"></script>
    <script type="text/javascript">
        $(function() {

            var table1 = $('.just-dial-leads-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('just-dial-leads') }}",
                    data: function(d) {
                        d.branch = $('#branch option:selected').val(),
                            d.dateRange = $('#date_range').val(),
                            d.cluster = $('#cluster').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'clusterName',
                        name: 'cluster_master.name'
                    },
                    {
                        data: 'branchName',
                        name: 'branch_master.name'
                    },
                    {
                        data: 'dateTime',
                        name: 'dateTime',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'mobile',
                        name: 'mobile'
                    },
                    {
                        data: 'email',
                        name: 'email'
                    },
                    {
                        data: 'category',
                        name: 'category'
                    },
                    {
                        data: 'city',
                        name: 'city'
                    },
                    {
                        data: 'area',
                        name: 'area'
                    },
                    {
                        data: 'brancharea',
                        name: 'brancharea'
                    },
                    {
                        data: 'remarks',
                        name: 'remarks'
                    },
                    {
                        data: 'readStatus',
                        name: 'readStatus',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'leadStatus',
                        name: 'leadStatus',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]

            });

            $(document).on('change', '.common-on-change', function() {
                table1.draw();
            });

        });
    </script>
@endsection
