@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection

@section('content')
    <style>
        .dark-theme .nav-tabs .nav-link {
            font-size: 12px;
        }

        .ongoing-calls-datatable td:nth-child(10) {
            white-space: normal;
            word-wrap: break-word;
            word-break: break-all;
        }
    </style>
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            @include('report_filters', [
                'branch' => true,
                'agent' => true,
                'cluster' => true,
            ])

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive border userlist-table">
                                <table
                                    class="table card-table custom-dt-style table-striped table-vcenter text-nowrap mb-0 ongoing-calls-datatable"
                                    style="width: 100%">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Cluster</th>
                                            <th class="wd-20p">Branch</th>
                                            <th class="wd-20p">Agent Name</th>
                                            <th class="wd-20p">Customer Name</th>
                                            <th class="wd-20p">Mobile</th>
                                            <th class="wd-20p">Date</th>
                                            <th class="wd-20p">Description</th>
                                            <th class="wd-20p">Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    <script type="text/javascript">
        $(function() {

            var table1 = $('.ongoing-calls-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('ongoing-calls') }}",
                    data: function(d) {
                        d.branch = $('#branch option:selected').val(),
                            d.agent = $('#agent option:selected').val(),
                            d.dateRange = $('#date_range').val(),
                            d.cluster = $('#cluster').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'clusterName',
                        name: 'cluster_master.name'
                    },
                    {
                        data: 'branchName',
                        name: 'branch_master.name'
                    },
                    {
                        data: 'agentName',
                        name: 'agent_master.name',
                    },
                    {
                        data: 'customer_name',
                        name: 'beneficiary_import.customer_name'
                    },
                    {
                        data: 'mobile_number',
                        name: 'beneficiary_import.mobile_number'
                    },
                    {
                        data: 'invoice_date',
                        name: 'beneficiary_import.invoice_date'
                    },
                    {
                        data: 'description',
                        name: 'beneficiary_import.description'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]

            });

            $(document).on('change', '.common-on-change', function() {
                table1.draw();
            });

        });
    </script>
@endsection
