<div class="@if ($data->screen == 'dashboard-report') col-md-6 @else col-md-4 @endif">
    <div class="table-responsive">
        <table class="table districtwise" id="districtwise">
            <thead>
                <tr>
                    <th class="wd-5p">S.No</th>
                    <th class="wd-10p">Name</th>
                    <th class="wd-5p">Total Calls</th>
                    @if ($data->screen == 'dashboard-report')
                        <th class="wd-5p">Feedback</th>
                        <th class="wd-5p">Complaints</th>
                        @if (isset($data->fieldType) && $data->fieldType == 'Total Complaints')
                            <th class="wd-5p">Resolved</th>
                        @endif
                    @endif
                </tr>
            </thead>
            <tbody>
                @foreach ($data as $key => $district)
                    <tr>
                        <td class="">{{ $key + 1 }}</td>
                        <td class="">{{ $district->district }}</td>
                        <td class="">{{ $district->count }}</td>
                        @if ($data->screen == 'dashboard-report')
                            <td class="">{{ isset($district->feedbackCount) ? $district->feedbackCount : 0 }}</td>
                            <td class="">{{ isset($district->complaintCount) ? $district->complaintCount : 0 }}
                            </td>
                            @if (isset($data->fieldType) && $data->fieldType == 'Total Complaints')
                                <td class="">{{ isset($district->resolvedCount) ? $district->resolvedCount : 0 }}
                                </td>
                            @endif
                        @endif
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
