<div class="row">
    <h5>Salient App Followup</h5>
    <div class="table-responsive border">
        <table class="table text-nowrap text-md-nowrap table-bordered mg-b-0" style="width: 100%">
            <thead>
                <tr>
                    <td class="text-center"></td>
                    <td class="text-center" colspan="2">Grand Total</td>
                    @foreach ($result->dates as $date)
                        <td class="text-center" colspan="2">{{ $date->displayFormat }}</td>
                    @endforeach
                </tr>
                <tr>
                    <td class="text-center">Branch</td>
                    <td class="text-center">Qty</td>
                    <td class="text-center">Price</td>
                    @foreach ($result->dates as $date)
                        <td class="text-center">Qty</td>
                        <td class="text-center">Price</td>
                    @endforeach
                </tr>
            </thead>
            <tbody>
                @php
                    $columnGrandTotalQty = 0;
                    $columnGrandTotalPrice = 0;
                    $dailyGrandTotals = [];
                @endphp
                @foreach ($result->branches as $branch)
                    @php
                        $totalQty = 0;
                        $totalPrice = 0;
                        $dailyData = [];
                    @endphp
                    @foreach ($result->dates as $date)
                        @php
                            $qty = 0;
                            $price = 0;
                        @endphp
                        @foreach ($result->dateWiseData as $row)
                            @if ($row->date == $date->dbFormat && $branch->id == $row->branch_id)
                                @php
                                    $qty = $row->qty;
                                    $price = $row->price;
                                @endphp
                            @endif
                        @endforeach
                        @php
                            $totalQty += $qty;
                            $totalPrice += $price;
                            $dailyData[] = ['qty' => $qty, 'price' => $price];

                            $columnGrandTotalQty += $qty;
                            $columnGrandTotalPrice += $price;

                            // Store grand totals for each date
                            if (!isset($dailyGrandTotals[$date->dbFormat])) {
                                $dailyGrandTotals[$date->dbFormat] = ['qty' => 0, 'price' => 0];
                            }
                            $dailyGrandTotals[$date->dbFormat]['qty'] += $qty;
                            $dailyGrandTotals[$date->dbFormat]['price'] += $price;
                        @endphp
                    @endforeach
                    <tr>
                        <td class="text-center">{{ $branch->name }}</td>
                        <td class="text-center font-weight-bold">{{ !empty($totalQty) ? $totalQty : '-' }}</td>
                        <td class="text-center font-weight-bold">{{ !empty($totalPrice) ? $totalPrice : '-' }}</td>
                        @foreach ($dailyData as $data)
                            <td class="text-center">{{ !empty($data['qty']) ? $data['qty'] : '-' }}</td>
                            <td class="text-center">{{ !empty($data['price']) ? $data['price'] : '-' }}</td>
                        @endforeach
                    </tr>
                @endforeach
                <tr>
                    <td class="text-center font-weight-bold">Grand Total</td>
                    <td class="text-center font-weight-bold">
                        {{ !empty($columnGrandTotalQty) ? $columnGrandTotalQty : '-' }}</td>
                    <td class="text-center font-weight-bold">
                        {{ !empty($columnGrandTotalPrice) ? $columnGrandTotalPrice : '-' }}</td>
                    @foreach ($result->dates as $date)
                        <td class="text-center font-weight-bold">
                            {{ !empty($dailyGrandTotals[$date->dbFormat]['qty']) ? $dailyGrandTotals[$date->dbFormat]['qty'] : '-' }}
                        </td>
                        <td class="text-center font-weight-bold">
                            {{ !empty($dailyGrandTotals[$date->dbFormat]['price']) ? $dailyGrandTotals[$date->dbFormat]['price'] : '-' }}
                        </td>
                    @endforeach
                </tr>
            </tbody>

            {{-- <tbody>
                @foreach ($result->branches as $branch)
                    @php
                        $totalQty = 0;
                        $totalPrice = 0;
                    @endphp
                    <tr>
                        <td class="text-center">{{ $branch->name }}</td>
                        @foreach ($result->dates as $date)
                            @php
                                $data = collect($result->dateWiseData)
                                    ->where('date', $date->dbFormat)
                                    ->where('branch_id', $branch->id)
                                    ->first();

                                $qty = $data->qty ?? 0;
                                $price = $data->price ?? 0;

                                $totalQty += $qty;
                                $totalPrice += $price;
                            @endphp
                            <td class="text-center">{{ !empty($qty) ? $qty : '' }}</td>
                            <td class="text-center">{{ !empty($price) ? $price : '' }}</td>
                        @endforeach
                        <td class="text-center font-weight-bold">{{ !empty($totalQty) ? $totalQty : '' }}</td>
                        <td class="text-center font-weight-bold">{{ !empty($totalPrice) ? round($totalPrice, 2) : '' }}
                        </td>
                    </tr>
                @endforeach
            </tbody> --}}
        </table>
    </div>
</div>
<div class="row mt-5">
    <div class="col-md-6">
        <h5>Product Class Wise Enquiry</h5>
        <div class="table-responsive border">
            <table class="table text-nowrap text-md-nowrap table-bordered mg-b-0" style="width: 100%">
                <thead>
                    <tr>
                        <th>Product Class</th>
                        <th>Qty</th>
                        <th>Price</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $productQty = 0;
                        $productPrice = 0;
                    @endphp
                    @foreach ($result->productWiseData as $product)
                        @php
                            $productQty += $product->qty;
                            $productPrice += $product->price;
                        @endphp
                        <tr>
                            <td class="text-center">{{ $product->product }}</td>
                            <td class="text-center">{{ $product->qty }}</td>
                            <td class="text-center">{{ $product->price }}</td>
                        </tr>
                    @endforeach
                    <tr>
                        <td class="text-center">Grand Total</td>
                        <td class="text-center">{{ $productQty }}</td>
                        <td class="text-center">{{ $productPrice }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <div class="col-md-6">
        <h5>Enquiry Remarks</h5>
        <div class="table-responsive border">
            <table class="table text-nowrap text-md-nowrap table-bordered mg-b-0" style="width: 100%">
                <thead>
                    <tr>
                        <th>Enquiry Remarks</th>
                        <th>Qty</th>
                        <th>Price</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $enquiryQty = 0;
                        $enquiryPrice = 0;
                    @endphp
                    @foreach ($result->enquiryWiseData as $enquiry)
                        @php
                            $enquiryQty += $enquiry->qty;
                            $enquiryPrice += $enquiry->price;
                        @endphp
                        <tr>
                            <td class="text-center">{{ $enquiry->enquiry_reason }}</td>
                            <td class="text-center">{{ $enquiry->qty }}</td>
                            <td class="text-center">{{ $enquiry->price }}</td>
                        </tr>
                    @endforeach
                    <tr>
                        <td class="text-center">Grand Total</td>
                        <td class="text-center">{{ $enquiryQty }}</td>
                        <td class="text-center">{{ $enquiryPrice }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
