@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table user-datatable" id="user-datatable">
                                    <thead>
                                        <tr>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Name</th>
                                            <th class="wd-25p">Email</th>
                                            <th class="wd-25p">Phone</th>
                                            <th class="wd-20p">Role</th>
                                            <th class="wd-20p">Status</th>
                                            <th class="wd-20p">Action</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script type="text/javascript">
        $(function() {
            var table = $('.user-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('user.index') }}",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'email',
                        name: 'email'
                    },
                    {
                        data: 'phone',
                        name: 'phone'
                    },
                    {
                        data: 'role',
                        name: 'role_master.description'
                    },
                    {
                        data: 'status',
                        name: 'status'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });
        });
    </script>
@endsection
