<?php

use App\Http\Controllers\API\CallHistoryController;
use App\Http\Controllers\API\CRMTicketController;
use App\Http\Controllers\API\JustDialController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ExcelCampaignController;
use App\Http\Controllers\FeedbackController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\Masters\AgentMasterController;
use App\Http\Controllers\Masters\CampaignController;
use App\Http\Controllers\SalesController;
use App\Http\Controllers\Transactions\CallCenterController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\WebhookController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
 */


Route::middleware(['guest'])->group(function () {
    Route::post('/login', [LoginController::class, 'login']);
    Route::resource('call-history', 'App\Http\Controllers\API\CallHistoryController');
    Route::get('init-call', [CallCenterController::class, 'initCall']);
    Route::post('/add-sales-enquiry', [SalesController::class, 'addSalesEnquiryData']);
    Route::post('/cancel-sales-order', [SalesController::class, 'cancelSalesOrder']);
    Route::post('/pushcalllog', [CallHistoryController::class, 'pushCallLog']);
    Route::post('/employeewise-attendance', [CallHistoryController::class, 'employeewiseAttendance']);
    Route::post('/overall-attendance', [CallHistoryController::class, 'overallAttendance']);
    Route::post('/just-dial-leads', [JustDialController::class, 'addLeads']);
    Route::post('/add-crm-ticket', [CRMTicketController::class, 'addCRMTicket']);
});

Route::middleware(['auth:sanctum'])->group(function () {
    Route::post('/auto-dialer-list', [CallCenterController::class, 'getDialerList']);
    Route::post('/get-dialer-counts', [CallCenterController::class, 'getDialerCounts']);
    Route::post('/save-feedback', [FeedbackController::class, 'saveFeedbackApp']);
    Route::post('/get-feedback-history', [FeedbackController::class, 'getFeedbackHistory']);
    Route::post('/get-call-skip-reasons', [CallCenterController::class, 'getCallSkipReasons']);
    Route::post('/update-call-skip-reasons', [CallCenterController::class, 'updateCallSkipReasons']);
    Route::post('/make-call', [CallCenterController::class, 'makeCallApp']);
    Route::post('/save-recordings', [CallCenterController::class, 'saveRecordings']);
    Route::post('/save-call-logs', [CallCenterController::class, 'saveCallLogs']);
    Route::post('/get-campaign', [CampaignController::class, 'getCampaign']);
    Route::get('/logout', [LoginController::class, 'appLogout']);
    Route::post('/get-user-dashboard', [DashboardController::class, 'appUserDashboard']);
    Route::post('/update-lead-status', [CallCenterController::class, 'updateLeadStatus']);
    Route::get('/get-agents-list', [AgentMasterController::class, 'getAgentsList']);
    Route::post('/excel-campaign-list', [ExcelCampaignController::class, 'excelCampaignList']);
    Route::post('/assign-campaign-leads', [ExcelCampaignController::class, 'assignCampaignLeads']);
});

// Route::post('/request-log', function (Request $request) {
//     $payload = $request->getContent();
//     $ip = $request->ip();
//     $contentType = $request->header('content-type');
//     $timestamp = now()->toISOString();

//     // Prevent extremely large entries
//     $maxLength = 10000; // 10 KB cap
//     if (strlen($payload) > $maxLength) {
//         $payload = substr($payload, 0, $maxLength) . '... [truncated]';
//     }

//     Log::channel('requestlog')->info('Inbound request body', [
//         'time' => $timestamp,
//         'ip' => $ip,
//         'content_type' => $contentType,
//         'body' => $payload,
//     ]);

//     return response()->json(['status' => 'ok']);
// });

Route::post('/request-log', function (Request $request) {
    $payload   = $request->getContent();
    $timestamp = now()->toISOString();
    $ip        = $request->ip();
    $data      = json_decode($payload, true);

    if (!is_array($data)) {
        Log::channel('requestlog')->warning('Invalid JSON', ['payload' => $payload]);
        return response()->json(['status' => 'invalid']);
    }

    // --- Extract fields ------------------------------------------------------
    $waId   = $data['waId'] ?? null;
    $convId = $data['conversationId'] ?? null;
    $name   = $data['senderName'] ?? null;
    $event  = $data['eventType'] ?? null;
    $text   = $data['text'] ?? '';
    $product = $data['listReply']['title'] ?? null;

    // --- Detect coupon & branch ----------------------------------------------
    preg_match('/VIVI\d+/i', $text, $couponMatch);
    $coupon = $couponMatch[0] ?? null;

    $branch = null;
    if (preg_match('/Branch Name:\s*(.*)/i', $text, $m)) {
        $branch = trim($m[1]);
    }

    // Derive city (same as branch here)
    $city = $branch;

    // --- Prepare structured payload for both DB and log ----------------------
    $record = [
        'ip'              => $ip,
        'wa_id'           => $waId,
        'conversation_id' => $convId,
        'sender_name'     => $name,
        'product'         => $product,
        'branch'          => $branch,
        'coupon_code'     => $coupon,
        'city'            => $city,
        'last_update'     => $timestamp,
        'event'           => $event,
    ];

    // --- Always log in a unified table-like format ---------------------------
    Log::channel('requestlog')->info('Inbound request', $record);

    // --- Persist to DB only when waId or conversationId exists ---------------
    // if ($waId || $convId) {
    //     $keyColumn = $waId ? 'wa_id' : 'conversation_id';
    //     $keyValue  = $waId ?: $convId;

    //     $existing = DB::table('viveks_sessions')
    //         ->where($keyColumn, $keyValue)
    //         ->first();

    //     $mergedRaw = [];
    //     if ($existing && $existing->raw_messages) {
    //         $mergedRaw = json_decode($existing->raw_messages, true);
    //     }
    //     $mergedRaw[] = [
    //         'time'  => $timestamp,
    //         'event' => $event,
    //         'text'  => $text,
    //     ];

    //     $update = [
    //         'conversation_id' => $convId ?? $existing->conversation_id ?? null,
    //         'sender_name'     => $name ?? $existing->sender_name ?? null,
    //         'product'         => $product ?? $existing->product ?? null,
    //         'branch'          => $branch ?? $existing->branch ?? null,
    //         'coupon_code'     => $coupon ?? $existing->coupon_code ?? null,
    //         'city'            => $city ?? $existing->city ?? null,
    //         'last_update'     => now(),
    //         'raw_messages'    => json_encode($mergedRaw),
    //         'updated_at'      => now(),
    //     ];

    //     // if ($existing) {
    //     //     DB::table('viveks_sessions')->where($keyColumn, $keyValue)->update($update);
    //     // } else {
    //     //     $update[$keyColumn] = $keyValue;
    //     //     $update['created_at'] = now();
    //     //     DB::table('viveks_sessions')->insert($update);
    //     // }
    // }

    return response()->json(['status' => 'ok']);
});

Route::match(['get', 'post'], '/viveks-wati-webhook', [WebhookController::class, 'store']);
