<?php

use App\Http\Controllers\API\TestController;
use App\Http\Controllers\ArtisanCmdController;
use App\Http\Controllers\CommonController;
use App\Http\Controllers\CRM\Masters\ProductController;
use App\Http\Controllers\CRM\Masters\RequestCategoryController;
use App\Http\Controllers\CRM\Masters\SubDepartmentController;
use App\Http\Controllers\CRM\Masters\TicketCategoryController;
use App\Http\Controllers\CRM\Masters\TicketsContoller;
use App\Http\Controllers\CRM\Masters\TicketSourceController;
use App\Http\Controllers\CRM\Masters\CrmBrandController;
use App\Http\Controllers\CronController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\FeedbackController;
use App\Http\Controllers\GoogleSheetController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\Masters\AgentMappingController;
use App\Http\Controllers\Masters\AgentMasterController;
use App\Http\Controllers\Masters\ClusterMasterController;
use App\Http\Controllers\Masters\BranchController;
use App\Http\Controllers\Masters\BrandController;
use App\Http\Controllers\Masters\CallReasonController;
use App\Http\Controllers\Masters\CampaignController;
use App\Http\Controllers\Masters\DesignationController;
use App\Http\Controllers\Masters\PrivilegesController;
use App\Http\Controllers\Masters\RoleController;
use App\Http\Controllers\Masters\SettingsController;
use App\Http\Controllers\Masters\UserController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ReferralCampaignController;
use App\Http\Controllers\Reports\AgentwiseCallsController;
use App\Http\Controllers\Reports\AnalyticsDashboard;
use App\Http\Controllers\Reports\BranchSummaryController;
use App\Http\Controllers\Reports\CallLogsReportController;
use App\Http\Controllers\Reports\NocallAgentReportController;
use App\Http\Controllers\Reports\CallsDialledController;
use App\Http\Controllers\Reports\CallsReportController;
use App\Http\Controllers\Reports\ConnectedConvertedReportController;
use App\Http\Controllers\Reports\CRMReportController;
use App\Http\Controllers\Reports\DailyReportController;
use App\Http\Controllers\Reports\EmployeeSummaryController;
use App\Http\Controllers\Reports\SalientSummaryController;
use App\Http\Controllers\Reports\EnquiryReportController;
use App\Http\Controllers\Reports\JustDialReportController;
use App\Http\Controllers\Reports\NocallNologinReportController;
use App\Http\Controllers\Reports\NoLoginNoCallsController;
use App\Http\Controllers\Reports\OngoingCallsController;
use App\Http\Controllers\Reports\PresentLoggedInReportController;
use App\Http\Controllers\Reports\ProgramwiseReportController;
use App\Http\Controllers\Reports\ReferralReportController;
use App\Http\Controllers\Reports\ReportController;
use App\Http\Controllers\Reports\SalesAnalysisReportController;
use App\Http\Controllers\Reports\SalesReportController;
use App\Http\Controllers\Reports\VendorCampaignReportController;
use App\Http\Controllers\Transactions\CallCenterController;
use App\Http\Controllers\Transactions\CallMappingController;
use App\Http\Controllers\Transactions\ResendCouponsController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

Route::middleware(['guest'])->group(function () {
    Route::get('/', [LoginController::class, 'index'])->name('login');
    Route::get('/login', [LoginController::class, 'index'])->name('login-child');
    Route::any('/validate-login', [LoginController::class, 'checkLogin'])->name('validate-login');
});

//artisan cmd
Route::get('/artisan-cmd/{type}', [ArtisanCmdController::class, 'index'])->name('artisanCmd');

Route::middleware(['auth'])->group(function () {
    Route::get('/logout', [LoginController::class, 'logout'])->name('logout');

    //dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/home', [DashboardController::class, 'index'])->name('dashboardHome');
    Route::post('/get-dashboard-data', [DashboardController::class, 'getDashboardData'])->name('dashboard.getData');
    Route::get('/get-detailed-ajax', [DashboardController::class, 'detailedReportAjax'])->name('dashboard.detailedReportAjax');
    Route::get('detailed-report-dashboard/{type?}/{from?}/{to?}/{cluster?}/{branch?}/{agent?}/', [DashboardController::class, 'detailedReport'])->name('dashboard.detailedReport');

    //profile
    Route::resource('/profile', ProfileController::class);
    //user
    Route::resource('/user', UserController::class);
    //settings
    Route::resource('/settings', SettingsController::class);
    Route::post('/delete-pending-calls', [SettingsController::class, 'deletePendingCalls'])->name('deletePendingCalls');
    Route::post('/reallocate-calls', [SettingsController::class, 'reallocateCalls'])->name('reallocateCalls');
    Route::resource('/campaign', CampaignController::class);
    Route::resource('/call-reasons', CallReasonController::class);

    //feedback
    Route::resource('/feedback', FeedbackController::class);
    Route::get('/feedback/create-new/{id}', [FeedbackController::class, 'newFeedback'])->name('feedback.createNew');
    Route::post('/save-feedback', [FeedbackController::class, 'saveFeedback'])->name('feedback.saveFeedback');
    Route::post('/resolve-feedback', [FeedbackController::class, 'resolveFeedback'])->name('resolveFeedback');

    //common functions
    Route::get('/common/active/{id}/{type}/{name}', [CommonController::class, 'updateStatus'])->name('common.active');
    Route::get('/common/inactive/{id}/{type}/{name}', [CommonController::class, 'updateStatus'])->name('common.inactive');
    Route::get('/common/delete/{id}/{type}/{name}', [CommonController::class, 'updateStatus'])->name('common.delete');
    Route::post('/{master}/{id}/common/check-user-email', [CommonController::class, 'checkUserEmail'])->name('edit.checkUserMail');
    Route::post('/{master}/common/check-user-email', [CommonController::class, 'checkUserEmail'])->name('add.checkUserMail');
    Route::get('/download/{type}/{file}', [CommonController::class, 'downloadAttachments'])->name('downloadAttachments');
    Route::post('update-theme', [CommonController::class, 'updateTheme'])->name('updateTheme');

    //role master
    Route::resource('/role', RoleController::class);

    //agent master
    Route::resource('/agent-master', AgentMasterController::class);

    //agent mapping
    Route::resource('/agent-mapping', AgentMappingController::class);

    //cluster master
    Route::resource('/cluster-master', ClusterMasterController::class);


    //call center controller
    Route::resource('/caller', CallCenterController::class);
    Route::get('/import-beneficiary', [CallCenterController::class, 'getImportPage'])->name('caller.getImport');
    Route::post('/import', [CallCenterController::class, 'import'])->name('caller.import-beneficiary');
    Route::post('/import-save', [CallCenterController::class, 'saveImport'])->name('caller.saveImport');
    Route::post('/caller/get-master-feedback-form', [CallCenterController::class, 'getMasterFeedbackForm'])->name('caller.getMasterFeedbackForm');
    Route::post('/caller/make-call', [CallCenterController::class, 'makeCall'])->name('caller.makeCall');
    Route::get('/callbacklist', [CallCenterController::class, 'callbackList'])->name('caller.callbackList');
    Route::get('/call-another-list', [CallCenterController::class, 'callAnotherNumberList'])->name('caller.callAnotherNumberList');
    Route::any('/caller/call-status-update', [CallCenterController::class, 'updateCallStatus'])->name('caller.updateCallStatus');
    Route::any('/download-pending-calls', [CallCenterController::class, 'downloadPendingCalls'])->name('downloadPendingCalls');

    //role master
    Route::resource('/designation', DesignationController::class);
    //privileges
    Route::resource('/privileges', PrivilegesController::class);

    //Brand master
    Route::resource('/brand', BrandController::class);
    Route::resource('/resend-coupons', ResendCouponsController::class);

    //referral campaign
    Route::resource('/referral-campaign', ReferralCampaignController::class);

    //call mapping
    Route::resource('/call-mapping', CallMappingController::class);
    Route::resource('/branch', BranchController::class);
    Route::post('get-branches-ajax', [DashboardController::class, 'getBranches'])->name('getBranches');
    Route::post('get-products-ajax', [CallMappingController::class, 'getProducts'])->name('getProducts');
    Route::post('get-agents-ajax', [CallMappingController::class, 'getAgents'])->name('getAgents');
    Route::post('get-customer-list', [CallMappingController::class, 'getCustomerList'])->name('getCustomerList');

    //get ajax from dropdowns
    Route::post('{screen?}/get-programs-ajax', [CommonController::class, 'getPrograms'])->name('common.getPrograms');
    Route::post('{screen?}/get-block-ajax', [CommonController::class, 'getBlocks'])->name('common.getBlocks');
    Route::post('{screen?}/get-awc-ajax', [CommonController::class, 'getAwcs'])->name('common.getAwcs');
    Route::post('{screen?}/get-sector-ajax', [CommonController::class, 'getSector'])->name('common.getSector');
    Route::post('{screen?}/get-program-questions-ajax', [CommonController::class, 'getProgramQuestions'])->name('common.getProgramQuestions');
    Route::post('{screen?}/get-program-answers-ajax', [CommonController::class, 'getProgramAnswers'])->name('common.getProgramAnswers');

    //edit routes
    Route::post('{screen?}/{id?}/get-programs-ajax', [CommonController::class, 'getPrograms'])->name('common.getEditPrograms');
    Route::post('{screen?}/{id?}/get-block-ajax', [CommonController::class, 'getBlocks'])->name('common.getEditBlocks');
    Route::post('{screen?}/{id?}/get-awc-ajax', [CommonController::class, 'getAwcs'])->name('common.getEditAwcs');
    Route::post('{screen?}/{id?}/get-sector-ajax', [CommonController::class, 'getSector'])->name('common.getEditSector');
    Route::post('{screen?}/{id?}/get-program-questions-ajax', [CommonController::class, 'getProgramQuestions'])->name('common.getEditProgramQuestions');
    Route::post('{screen?}/{id?}/get-program-answers-ajax', [CommonController::class, 'getProgramAnswers'])->name('common.getEditProgramAnswers');

    Route::post('update-status-ajax', [CommonController::class, 'UpdateStatusAjax'])->name('UpdateStatusAjax');

    //reports
    Route::any('programwise-report', [ProgramwiseReportController::class, 'index'])->name('programwise-report');
    Route::get('/programwise-report-detailed', [ReportController::class, 'getProgramwiseDetailsReportAjax'])->name('programwise-report-detailed');
    Route::any('/navigate-report', [ReportController::class, 'navigateToReport'])->name('navigateReport');

    //for exporting excel in list page 
    Route::any('/export-excel-by-id/{id?}/{name?}', [ReportController::class, 'exportExcelById'])->name('exportExcelById');

    //daily report
    Route::any('daily-report', [DailyReportController::class, 'index'])->name('daily-report');

    //calls report
    Route::any('calls-report', [CallsReportController::class, 'index'])->name('calls-report');
    Route::any('calls-dialled', [CallsDialledController::class, 'index'])->name('calls-dialled');
    Route::get('view-transcript/{id}', [CallsDialledController::class, 'viewTranscript'])->name('view-transcript');
    Route::any('present-loggedin', [PresentLoggedInReportController::class, 'index'])->name('present-loggedin');
    Route::any('just-dial-leads', [JustDialReportController::class, 'index'])->name('just-dial-leads');
    Route::any('update-leads', [JustDialReportController::class, 'updateLeadStatus'])->name('updateLeadStatus');
    Route::any('connected-converted', [ConnectedConvertedReportController::class, 'index'])->name('connected-converted');
    Route::any('ongoing-calls', [OngoingCallsController::class, 'index'])->name('ongoing-calls');
    Route::any('update-calls/{id?}', [OngoingCallsController::class, 'updateCallStatus'])->name('updateCallStatus');

    //call logs
    Route::any('call-logs', [CallLogsReportController::class, 'index'])->name('call-logs');
    //nocall agents
    Route::any('nocall-agents', [NocallAgentReportController::class, 'index'])->name('nocall-agents');

    Route::any('crm-tickets', [CRMReportController::class, 'index'])->name('crm-tickets');
    Route::any('sales-report', [SalesReportController::class, 'index'])->name('sales-report');
    Route::any('enquiry-report', [EnquiryReportController::class, 'index'])->name('enquiry-report');
    Route::any('no-login-no-calls', [NoLoginNoCallsController::class, 'index'])->name('no-login-no-calls');
    Route::any('agentwise-calls', [AgentwiseCallsController::class, 'index'])->name('agentwise-calls');
    Route::any('nologin-nocalls', [NocallNologinReportController::class, 'index'])->name('nologin-nocalls');
    Route::any('referral-report', [ReferralReportController::class, 'index'])->name('referral-report');
    Route::any('sales-analysis', [SalesAnalysisReportController::class, 'index'])->name('sales-analysis');
    Route::post('get-sales-analysis', [SalesAnalysisReportController::class, 'getSalesAnalysisData'])->name('getSalesAnalysisData');
    Route::any('branch-summary', [BranchSummaryController::class, 'index'])->name('branch-summary');
    Route::post('get-branch-data', [BranchSummaryController::class, 'getBranchData'])->name('getBranchData');
    Route::any('employee-summary', [EmployeeSummaryController::class, 'index'])->name('employee-summary');
    Route::post('get-employee-data', [EmployeeSummaryController::class, 'getEmployeeData'])->name('getEmployeeData');
    Route::any('vendor-campaign', [VendorCampaignReportController::class, 'index'])->name('vendor-campaign');
    Route::any('salient-summary', [SalientSummaryController::class, 'index'])->name('salient-summary');
    Route::post('get-salient-data', [SalientSummaryController::class, 'getSailientData'])->name('getSailientData');
    Route::any('analytics-dashboard', [AnalyticsDashboard::class, 'index'])->name('analytics-dashboard');
    Route::any('get-analytics-dashboard', [AnalyticsDashboard::class, 'getDashboardData']);

    //google sheet reading
    Route::get('/read-sheet', [GoogleSheetController::class, 'readData']);

    //crm
    Route::resource('/crm-product', ProductController::class);
    Route::resource('/request-category', RequestCategoryController::class);
    Route::resource('/sub-department', SubDepartmentController::class);
    Route::resource('/ticket-category', TicketCategoryController::class);
    Route::resource('/ticket-source', TicketSourceController::class);
    Route::resource('/crm-brand', CrmBrandController::class);
    Route::resource('/tickets', TicketsContoller::class);
    Route::post('/get-sales-details', [TicketsContoller::class, 'getSalesDetails'])->name('getSalesDetails');
    Route::post('/get-sub-dept', [TicketsContoller::class, 'getSubDept'])->name('getSubDept');
    Route::post('/update-ticket', [TicketsContoller::class, 'updateTicket'])->name('updateTicket');
    Route::post('/transfer-close-leads', [TicketsContoller::class, 'transferCloseLeads'])->name('transferCloseLeads');
});

Route::any('/test/excecute-cmd', [TestController::class, 'assignExcelLeadsToBranch'])->name('testCmd');

//crons web routes
Route::any('/cron/auto-call-allocation', [CronController::class, 'autoCallAllocation']);
